/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="duiba")
public class DuibaDataSourceProperties {
    public static final String DUIBA_DATA_SOURCE_PROPERTIES_PREFIX = "duiba";
    private Map<String, DataSourcePropertiesInner> datasource = new LinkedHashMap<String, DataSourcePropertiesInner>();

    public Map<String, DataSourcePropertiesInner> getDatasource() {
        return this.datasource;
    }

    public void setDatasource(Map<String, DataSourcePropertiesInner> datasource) {
        this.datasource = datasource;
    }

    public static class DataSourcePropertiesInner {
        private static final Logger logger = LoggerFactory.getLogger(DataSourcePropertiesInner.class);
        private static final Class<?> HIKARI_CP_CLASS;
        private String driverClassName;
        private String url;
        private String username;
        private String password;
        private Integer maxTotal = 8;
        @Deprecated
        private Integer initialSize = 3;
        @Deprecated
        private Integer maxIdle = 8;
        private Integer minIdle = 0;
        private Integer maxWaitMillis = 3000;
        private Long maxLifetime = TimeUnit.MINUTES.toMillis(30L);
        private List<String> connectionInitSqls = new ArrayList<String>();

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public void setDriverClassName(String driverClassName) {
            this.driverClassName = driverClassName;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
        }

        public Integer getInitialSize() {
            return this.initialSize;
        }

        public void setInitialSize(Integer initialSize) {
            this.initialSize = initialSize;
        }

        public Integer getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
        }

        public Integer getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(Integer minIdle) {
            this.minIdle = minIdle;
        }

        public Integer getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setMaxWaitMillis(Integer maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public Long getMaxLifetime() {
            return this.maxLifetime;
        }

        public void setMaxLifetime(Long maxLifetime) {
            this.maxLifetime = maxLifetime;
        }

        public Class<? extends DataSource> getType() {
            try {
                Class.forName("com.zaxxer.hikari.HikariDataSource");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("\u68c0\u6d4b\u5230\u4f60\u7684\u9879\u76ee\u4e2d\u9700\u8981\u4f7f\u7528dataSource\uff0c\u76ee\u524d\u5f3a\u5236\u4f7f\u7528HikariCP\uff0c\u8bf7\u5f15\u5165HikariCP \u7684jar\u4f9d\u8d56.");
            }
            return HikariDataSource.class;
        }

        private boolean driverClassIsLoadable() {
            try {
                ClassUtils.forName((String)this.driverClassName, null);
                return true;
            }
            catch (UnsupportedClassVersionError ex) {
                throw ex;
            }
            catch (Throwable ex) {
                return false;
            }
        }

        public String determineDriverClassName() {
            if (StringUtils.hasText((String)this.driverClassName)) {
                Assert.state((boolean)this.driverClassIsLoadable(), () -> "Cannot load driver class: " + this.driverClassName);
                return this.driverClassName;
            }
            String driverClassName = null;
            if (StringUtils.hasText((String)this.url)) {
                if (this.url.startsWith("jdbc:mysql:")) {
                    driverClassName = "com.mysql.cj.jdbc.Driver";
                } else {
                    driverClassName = DatabaseDriver.fromJdbcUrl((String)this.url).getDriverClassName();
                    if (driverClassName == null && this.url.startsWith("jdbc:phoenix:")) {
                        driverClassName = "org.apache.phoenix.jdbc.PhoenixDriver";
                    }
                }
            }
            if (!StringUtils.hasText(driverClassName)) {
                throw new IllegalStateException("can't determine driverClassName of url:" + this.url);
            }
            return driverClassName;
        }

        public BeanDefinitionBuilder initializeDataSourceBeanDefinitionBuilder(String dataSourceName) {
            if (StringUtils.isEmpty((Object)this.url)) {
                return null;
            }
            Class<? extends DataSource> dataSourceClass = this.getType();
            if (HIKARI_CP_CLASS != null && HIKARI_CP_CLASS.isAssignableFrom(dataSourceClass)) {
                if (this.maxWaitMillis < 260) {
                    this.maxWaitMillis = 260;
                }
                int validationTimeout = Math.min(5000, Math.max(250, this.maxWaitMillis - 10));
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(dataSourceClass).addPropertyValue("driverClassName", (Object)this.determineDriverClassName()).addPropertyValue("jdbcUrl", (Object)this.getUrl()).addPropertyValue("maximumPoolSize", (Object)this.maxTotal).addPropertyValue("maxLifetime", (Object)this.maxLifetime).addPropertyValue("poolName", (Object)dataSourceName).addPropertyValue("minimumIdle", (Object)this.minIdle).addPropertyValue("connectionTimeout", (Object)this.maxWaitMillis).addPropertyValue("validationTimeout", (Object)validationTimeout).setDestroyMethodName("close");
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getUsername())) {
                    builder.addPropertyValue("username", (Object)this.getUsername());
                }
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getPassword())) {
                    builder.addPropertyValue("password", (Object)this.getPassword());
                }
                if (this.connectionInitSqls.size() == 1) {
                    builder.addPropertyValue("connectionInitSql", (Object)this.connectionInitSqls.get(0));
                } else if (this.connectionInitSqls.size() > 1) {
                    throw new IllegalStateException("connectionInitSqls\u53ea\u652f\u6301\u8bbe\u7f6e\u4e00\u4e2asql");
                }
                return builder;
            }
            throw new IllegalStateException("unsupportted dataSource type:" + dataSourceClass.getName() + ", currently only HikariCP is supported");
        }

        public void bindProperties(String dataSourceBeanName, DataSource dataSource) {
            ArrayList<DataSource> dataSourcesNeedChange = new ArrayList<DataSource>();
            dataSourcesNeedChange.add(dataSource);
            for (DataSource ds : dataSourcesNeedChange) {
                if (HIKARI_CP_CLASS != null && HIKARI_CP_CLASS.isAssignableFrom(ds.getClass())) {
                    if (this.maxWaitMillis < 260) {
                        this.maxWaitMillis = 260;
                    }
                    int validationTimeout = Math.min(5000, Math.max(250, this.maxWaitMillis - 10));
                    HikariDataSource d = (HikariDataSource)ds;
                    d.setMaximumPoolSize(this.maxTotal.intValue());
                    d.setMaxLifetime(this.maxLifetime.longValue());
                    d.setMinimumIdle(this.minIdle.intValue());
                    d.setConnectionTimeout((long)this.maxWaitMillis.intValue());
                    d.setValidationTimeout((long)validationTimeout);
                    continue;
                }
                logger.warn("\u4e0d\u80fd\u5237\u65b0\u6570\u636e\u6e90\u7c7b\u578b\uff1a{}, beanId:{}\uff0c\u5f53\u524d\u53ea\u652f\u6301\u5237\u65b0HikariCP\u6570\u636e\u6e90", (Object)ds.getClass().getName(), (Object)dataSourceBeanName);
            }
        }

        public List<String> getConnectionInitSqls() {
            return this.connectionInitSqls;
        }

        public void setConnectionInitSqls(List<String> connectionInitSqls) {
            this.connectionInitSqls = connectionInitSqls;
        }

        static {
            Class<?> hikariCpClass = null;
            try {
                hikariCpClass = Class.forName("com.zaxxer.hikari.HikariDataSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            HIKARI_CP_CLASS = hikariCpClass;
        }
    }
}

