/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.initserver;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.core.AsyncSpecifiedBeanPostProcessor;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.web.context.WebApplicationContext;

public class ApplicationListenerForAsyncSpecified
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationListenerForAsyncSpecified.class);
    private Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap;

    public ApplicationListenerForAsyncSpecified(Map<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> asyncProcessor2BeansMap) {
        this.asyncProcessor2BeansMap = asyncProcessor2BeansMap;
    }

    public int getOrder() {
        return -2;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        if (!(context instanceof WebApplicationContext)) {
            return;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(100, (ThreadFactory)new NamedThreadFactory("DuibaBootInitServerThread-"));
        int totalBean2ProcessCount = 0;
        for (Map<String, Object> map : this.asyncProcessor2BeansMap.values()) {
            totalBean2ProcessCount += map.size();
        }
        CountDownLatch countDownLatch = new CountDownLatch(totalBean2ProcessCount);
        for (Map.Entry<AsyncSpecifiedBeanPostProcessor, Map<String, Object>> entry : this.asyncProcessor2BeansMap.entrySet()) {
            Map<String, Object> beanMap = entry.getValue();
            AsyncSpecifiedBeanPostProcessor processor = entry.getKey();
            for (Map.Entry<String, Object> beanEntry : beanMap.entrySet()) {
                executorService.submit(() -> {
                    try {
                        processor.postProcessAfterInitialization(beanEntry.getValue(), (String)beanEntry.getKey());
                    }
                    catch (Exception e) {
                        logger.warn("Init failed", (Throwable)e);
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
        }
        try {
            boolean bl = countDownLatch.await(3L, TimeUnit.SECONDS);
            if (!bl) {
                logger.info("\u90e8\u5206\u529f\u80fd\u6ca1\u6709\u521d\u59cb\u5316\u6210\u529f");
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        executorService.shutdown();
    }
}

