/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.monitor.rpc.scan;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;

public class RpcConsumerScan {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcConsumerScan.class);
    private static final List<Class> INJECT_CLASS_LIST = new ArrayList<Class>();
    private static final Map<String, Set<String>> RPC_CONSUMER_CONFIG;

    public static void scanAndStore(ConfigurableListableBeanFactory beanFactory, String applicationName) {
        List scanPackageList = AutoConfigurationPackages.get((BeanFactory)beanFactory);
        for (String bd : beanFactory.getBeanDefinitionNames()) {
            boolean isWhitePackages;
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(bd);
            String beanClassName = beanDefinition.getBeanClassName();
            if (beanClassName == null || !(isWhitePackages = scanPackageList.stream().anyMatch(packageName -> beanClassName.startsWith((String)packageName)))) continue;
            Class<?> clazz = null;
            try {
                clazz = Class.forName(beanClassName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            RpcConsumerScan.analyseAndRegister(applicationName, clazz);
        }
    }

    private static void analyseAndRegister(String applicationName, Class<?> clazz) {
        List<Field> fields = RpcConsumerScan.getFieldList(clazz);
        for (Field field : fields) {
            if (!RpcConsumerScan.isInjectAnnotationPresent(field, INJECT_CLASS_LIST) || !field.getType().isAnnotationPresent(AdvancedFeignClient.class)) continue;
            String appName = RpcConsumerScan.injectValueFromPackages(field.getType().getPackage().getName());
            RpcConsumerScan.registerRpcMonitor(appName, field.getType().getName(), applicationName);
        }
    }

    private static String injectValueFromPackages(String packageName) {
        if (packageName == null) {
            return "";
        }
        try {
            Class.forName(packageName + ".package-info");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Package pkg = Package.getPackage(packageName);
        if (pkg == null) {
            return RpcConsumerScan.injectValueFromPackages(RpcConsumerScan.parentPackage(packageName));
        }
        Object[] properties = (AdvancedFeignClient[])pkg.getAnnotationsByType(AdvancedFeignClient.class);
        if (!ArrayUtils.isEmpty((Object[])properties)) {
            return properties[0].value();
        }
        return RpcConsumerScan.injectValueFromPackages(RpcConsumerScan.parentPackage(packageName));
    }

    private static String parentPackage(String packageName) {
        int idx = packageName.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return packageName.substring(0, idx);
    }

    private static List<Field> getFieldList(Class<?> clazz) {
        if (null == clazz || Objects.equals(Object.class, clazz)) {
            return Collections.emptyList();
        }
        Object[] fields = clazz.getDeclaredFields();
        ArrayList fieldList = Lists.newArrayList((Object[])fields);
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return fieldList;
        }
        fieldList.addAll(RpcConsumerScan.getFieldList(superClass));
        return fieldList;
    }

    private static boolean isInjectAnnotationPresent(Field field, List<Class> injectClassList) {
        if (field == null) {
            return false;
        }
        for (Class clazz : injectClassList) {
            if (!field.isAnnotationPresent(clazz)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void registerRpcMonitor(String application, String interfaceName, String applicationName) {
        if (StringUtils.isBlank((CharSequence)application)) {
            return;
        }
        if (application.equals(applicationName)) {
            return;
        }
        RPC_CONSUMER_CONFIG.compute(application, (k, v) -> {
            if (v == null) {
                HashSet<String> interfaceNameSet = new HashSet<String>();
                interfaceNameSet.add(interfaceName);
                return interfaceNameSet;
            }
            v.add(interfaceName);
            return v;
        });
    }

    public static Map<String, Set<String>> getRpcMonitorInfo() {
        return RPC_CONSUMER_CONFIG;
    }

    public static void registerInjectClass(List<Class> clazzList) {
        if (CollectionUtils.isEmpty(clazzList)) {
            return;
        }
        INJECT_CLASS_LIST.addAll(clazzList);
    }

    static {
        INJECT_CLASS_LIST.add(Autowired.class);
        INJECT_CLASS_LIST.add(Resource.class);
        RPC_CONSUMER_CONFIG = new ConcurrentHashMap<String, Set<String>>();
    }
}

