/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.perftest.dubbo;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.perftest.core.UnsupportedAppsHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;

public class PerfTestDubboRouter
extends AbstractRouter {
    public PerfTestDubboRouter(URL url) {
        this.setUrl(url);
    }

    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        String currentSceneId = PerfTestUtils.getSceneId();
        String targetAppName = null;
        ArrayList<Invoker<T>> testList = new ArrayList<Invoker<T>>(invokers.size());
        ArrayList<Invoker<T>> prodList = new ArrayList<Invoker<T>>(invokers.size());
        for (Invoker<T> invoker : invokers) {
            URL dubboUrl = invoker.getUrl();
            String targetSceneId = dubboUrl.getParameter("duibaNewPerfSceneId");
            if (StringUtils.isBlank(targetAppName)) {
                targetAppName = dubboUrl.getParameter("remote.application");
            }
            if (this.sceneIdEquals(currentSceneId, targetSceneId)) {
                testList.add(invoker);
            }
            if (!StringUtils.isBlank((CharSequence)targetSceneId)) continue;
            prodList.add(invoker);
        }
        if (CollectionUtils.isNotEmpty(testList)) {
            return testList;
        }
        if (StringUtils.isNotBlank((CharSequence)currentSceneId) && !UnsupportedAppsHolder.isUnsupportedApp(targetAppName)) {
            return Collections.emptyList();
        }
        return CollectionUtils.isNotEmpty(prodList) ? prodList : invokers;
    }

    private boolean sceneIdEquals(String currentSceneId, String targetSceneId) {
        if (currentSceneId == null || targetSceneId == null) {
            return false;
        }
        return currentSceneId.equals(targetSceneId);
    }
}

