/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class NewFeignJSONSerializationCompatibleCustomRequestInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NewFeignJSONSerializationCompatibleCustomRequestInterceptor.class);
    private static final Field REQUEST_TEMPLATE_QUERIES_FIELD;

    public void apply(RequestTemplate template) {
        if (REQUEST_TEMPLATE_QUERIES_FIELD == null) {
            return;
        }
        Map queries = template.queries();
        if (queries.size() == 0) {
            return;
        }
        LinkedHashMap newQueries = new LinkedHashMap();
        for (Map.Entry entry : queries.entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (!CollectionUtils.isNotEmpty((Collection)value)) continue;
            newQueries.put(entry.getKey(), value);
        }
        try {
            Map originalQueries = (Map)REQUEST_TEMPLATE_QUERIES_FIELD.get(template);
            originalQueries.clear();
        }
        catch (IllegalAccessException e) {
            log.error("\u83b7\u53d6RequestTemplate\u7684\u539f\u59cbqueries\u5f02\u5e38\uff0cNewFeignJSONSerializationCompatibleCustomRequestInterceptor\u4e0d\u751f\u6548\uff0c\u8bf7\u8054\u7cfb\u4e2d\u53f0\u89e3\u51b3", (Throwable)e);
            return;
        }
        template.queries(newQueries);
    }

    static {
        Field requestTemplateQueriesField = ReflectionUtils.findField(RequestTemplate.class, (String)"queries");
        if (requestTemplateQueriesField != null) {
            requestTemplateQueriesField.setAccessible(true);
        } else {
            log.error("RequestTemplate\u7c7b\u4e2d\u672a\u627e\u5230queries\u5c5e\u6027\uff0cNewFeignJSONSerializationCompatibleCustomRequestInterceptor\u4e0d\u751f\u6548\uff0c\u8bf7\u786e\u8ba4feign-core\u7684\u7248\u672c");
        }
        REQUEST_TEMPLATE_QUERIES_FIELD = requestTemplateQueriesField;
    }
}

