/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.FilterBasedRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.Random;

public class WeightedRandomRule
extends FilterBasedRule {
    private final Random random = new Random();

    public WeightedRandomRule(ILoadBalancer lb, List<RibbonServerListFilter> serverListFilters) {
        super(serverListFilters);
        this.setLoadBalancer(lb);
    }

    @Override
    protected Server chooseFromServers(List<Server> servers, ILoadBalancer lb, Object key) {
        Server server = null;
        int count = 0;
        int maxFindTimes = Math.min(10, servers.size() + 1);
        while (server == null && count++ < maxFindTimes) {
            server = this.chooseRoundRobinWithTimeBasedWeight(servers);
            if (server == null) {
                Thread.yield();
                continue;
            }
            return server;
        }
        if (count >= 10) {
            this.log.warn("No available alive servers after 10 tries from load balancer: " + lb);
        }
        return server;
    }

    private Server chooseRoundRobinWithTimeBasedWeight(List<Server> eligible) {
        int length = eligible.size();
        int totalWeight = 0;
        boolean sameWeight = true;
        int[] weights = new int[length];
        for (int i = 0; i < length; ++i) {
            int weight;
            weights[i] = weight = this.getTimeBasedWeight(eligible.get(i));
            totalWeight += weight;
            if (!sameWeight || i <= 0 || weight == weights[i - 1]) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            int offset = this.random.nextInt(totalWeight);
            for (int i = 0; i < length; ++i) {
                if ((offset -= weights[i]) >= 0) continue;
                return eligible.get(i);
            }
        }
        return eligible.get(this.random.nextInt(length));
    }
}

