/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer;

import cn.com.duiba.boot.netflix.ribbon.RibbonServerListFilter;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.loadbalancer.FilterBasedRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;

public class WeightedRoundRobinRule
extends FilterBasedRule {
    private static final int RECYCLE_PERIOD = 60000;
    private ConcurrentMap<String, WeightedRoundRobin> weightMap = new ConcurrentHashMap<String, WeightedRoundRobin>();

    public WeightedRoundRobinRule(ILoadBalancer lb, List<RibbonServerListFilter> serverListFilters) {
        super(serverListFilters);
        this.setLoadBalancer(lb);
    }

    @Override
    protected Server chooseFromServers(List<Server> servers, ILoadBalancer lb, Object key) {
        Server server = null;
        int count = 0;
        int maxFindTimes = Math.min(10, servers.size() + 1);
        while (server == null && count++ < maxFindTimes) {
            server = this.chooseSmoothRoundRobinWithTimeBasedWeight(servers);
            if (server == null) {
                Thread.yield();
                continue;
            }
            return server;
        }
        if (count >= 10) {
            this.log.warn("No available alive servers after 10 tries from load balancer: " + lb);
        }
        return server;
    }

    private Server chooseSmoothRoundRobinWithTimeBasedWeight(List<Server> eligible) {
        int totalWeight = 0;
        long maxCurrent = Long.MIN_VALUE;
        long now = System.currentTimeMillis();
        Server selectedServer = null;
        WeightedRoundRobin selectedWRR = null;
        for (Server server : eligible) {
            WeightedRoundRobin weightedRoundRobin;
            String serverId = server.getId();
            int weight = this.getTimeBasedWeight(server);
            if (weight != (weightedRoundRobin = this.weightMap.computeIfAbsent(serverId, k -> {
                WeightedRoundRobin wrr = new WeightedRoundRobin();
                wrr.setWeight(weight);
                return wrr;
            })).getWeight()) {
                weightedRoundRobin.setWeight(weight);
            }
            long cur = weightedRoundRobin.increaseCurrent();
            weightedRoundRobin.setLastUpdate(now);
            if (cur > maxCurrent) {
                maxCurrent = cur;
                selectedServer = server;
                selectedWRR = weightedRoundRobin;
            }
            totalWeight += weight;
        }
        if (eligible.size() != this.weightMap.size()) {
            this.weightMap.entrySet().removeIf(item -> now - ((WeightedRoundRobin)item.getValue()).getLastUpdate() > 60000L);
        }
        if (selectedServer != null) {
            selectedWRR.sel(totalWeight);
            return selectedServer;
        }
        return eligible.get(ThreadLocalRandom.current().nextInt(eligible.size()));
    }

    protected static class WeightedRoundRobin {
        private int weight;
        private AtomicLong current = new AtomicLong(0L);
        private long lastUpdate;

        protected WeightedRoundRobin() {
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
            this.current.set(0L);
        }

        public long increaseCurrent() {
            return this.current.addAndGet(this.weight);
        }

        public void sel(int total) {
            this.current.addAndGet(-1 * total);
        }

        public long getLastUpdate() {
            return this.lastUpdate;
        }

        public void setLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
        }
    }
}

