/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.profiler;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TimeProfileAspect {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *.*(..)) && @annotation(cn.com.duiba.boot.profiler.DBTimeProfiler)")
    public Object catTransactionAspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        DBTimeProfiler timeProfiler = signature.getMethod().getAnnotation(DBTimeProfiler.class);
        if (timeProfiler == null) {
            return joinPoint.proceed();
        }
        String methodName = signature.getMethod().getName();
        DBTimeProfile.enter((String)(signature.getMethod().getDeclaringClass().getSimpleName() + "." + methodName));
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            DBTimeProfile.release();
        }
    }
}

