package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duiba.wolf.spring.selfaware.SelfAware;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import org.apache.commons.collections.EnumerationUtils;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * for servlet
 * Created by hwq
 */
public class AccessLogFilter extends AbstractAccessLogFilter<HttpServletRequest, HttpServletResponse>
        implements Filter, SelfAware<AccessLogFilter> {

    @Deprecated
    private static final ThreadLocal<HttpServletRequest> requestThreadLocal=new ThreadLocal<>();

    public static final String OW_HOST = AbstractAccessLogFilter.OW_HOST;

    private static volatile AccessLogFilter selfBean;

    @Override
    public void init(FilterConfig filterConfig) {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        long start = System.currentTimeMillis();
        requestThreadLocal.set(req);

        try {
            doBefore(req, resp);
            filterChain.doFilter(req, resp);
        }finally {
            doAfter(req, resp, System.currentTimeMillis() - start);

            //清理ThreadLocal信息
            requestThreadLocal.remove();
        }
    }

    /**
     * 添加cookie信息到线程变量,日志优先从线程变量中获取
     * <br/>
     * 已经废弃，请替代为使用AccessLogFilter.putLogCookie(req, key, value)方法（需要先注入bean：@Resource private AccessLogFilter accessLogFilter; accessLogFilter.putLogCookie...）
     * @param key
     * @param value
     */
    @Deprecated
    public static void putLogCookie(String key,String value){
        HttpServletRequest req = AccessLogFilter.requestThreadLocal.get();
        selfBean.putLogCookie(req, key, value);
    }

    protected Map<String, String> getLogCookie(HttpServletRequest req){
        return (Map<String, String>)req.getAttribute(LOG_COOKIE_ATTRIBUTE_KEY);
    }

    /**
     * 设置appId
     * <br/>
     * 已经废弃，请替代为使用AccessLogFilter.setAppId(req, appId)方法（需要先注入bean：@Resource private AccessLogFilter accessLogFilter; accessLogFilter.setAppId...）
     * @param appId
     */
    @Deprecated
    public static void setAppId(Long appId){
        HttpServletRequest req = AccessLogFilter.requestThreadLocal.get();
        selfBean.setAppId(req, appId);
    }

    /**
     * 设置consumerId
     * <br/>
     * 已经废弃，请替代为使用AccessLogFilter.setConsumerId(req, consumerId)方法（需要先注入bean：@Resource private AccessLogFilter accessLogFilter; accessLogFilter.setConsumerId...）
     * @param consumerId
     */
    @Deprecated
    public static void setConsumerId(Long consumerId){
        HttpServletRequest req = AccessLogFilter.requestThreadLocal.get();
        selfBean.setConsumerId(req, consumerId);
    }

    public void setAppId(HttpServletRequest req, Long appId){
        req.setAttribute(APP_ID_ATTRIBUTE_KEY, appId);
    }

    public void setConsumerId(HttpServletRequest req, Long consumerId){
        req.setAttribute(CONSUMER_ID_ATTRIBUTE_KEY, consumerId);
    }

    protected Long getAppId(HttpServletRequest req){
        Long appId = (Long)req.getAttribute(APP_ID_ATTRIBUTE_KEY);
        return appId;
    }

    protected Long getConsumerId(HttpServletRequest req){
        Long consumerId = (Long)req.getAttribute(CONSUMER_ID_ATTRIBUTE_KEY);
        return consumerId;
    }

    @Override
    public void putLogCookie(HttpServletRequest req, String key, String value) {
        Map<String, String> map = (Map<String, String>)req.getAttribute(LOG_COOKIE_ATTRIBUTE_KEY);
        if(map == null){
            map = new HashMap<>();
            req.setAttribute(LOG_COOKIE_ATTRIBUTE_KEY, map);
        }

        map.put(key, value);
    }

    @Override
    public void putExPair(HttpServletRequest req, String key, Object value) {
        Map<String, Object> map = (Map<String, Object>)req.getAttribute(EX_ATTRIBUTE_KEY);
        if(map == null){
            map = new HashMap<>();
            req.setAttribute(EX_ATTRIBUTE_KEY, map);
        }

        map.put(key, value);
    }

    @Override
    public void putOverWritePair(HttpServletRequest req, String key, String value) {
        Map<String, String> map = (Map<String, String>)req.getAttribute(OVERWRITE_ATTRIBUTE_KEY);
        if(map == null){
            map = new HashMap<>();
            req.setAttribute(OVERWRITE_ATTRIBUTE_KEY, map);
        }

        map.put(key, value);
    }

    /**
     * 添加额外信息到线程变量,日志从线程变量获取信息进行打压输出
     * <br/>
     * 已经废弃，请替代为使用AccessLogFilter.putExPair(req, key, value)方法（需要先注入bean：@Resource private AccessLogFilter accessLogFilter; accessLogFilter.putExPair...）
     * @param key
     * @param value
     */
    @Deprecated
    public static void putExPair(String key,Object value){
        HttpServletRequest req = AccessLogFilter.requestThreadLocal.get();
        selfBean.putExPair(req, key, value);
    }

    protected Map<String, Object> getExPair(HttpServletRequest req){
        return (Map<String, Object>)req.getAttribute(EX_ATTRIBUTE_KEY);
    }

    /**
     * 添加host等覆盖信息到线程变量, 打印日志时优先从此处获取
     * <br/>
     * 已经废弃，请替代为使用AccessLogFilter.putOverwritePair(req, key, value)方法（需要先注入bean：@Resource private AccessLogFilter accessLogFilter; accessLogFilter.putOverWritePair...）
     * @param key
     * @param value
     */
    @Deprecated
    public static void putOverWritePair(String key, String value){
        HttpServletRequest req = AccessLogFilter.requestThreadLocal.get();
        selfBean.putOverWritePair(req, key, value);
    }

    protected String getHost(HttpServletRequest req){
        Map<String, String> map = (Map<String, String>)req.getAttribute(OVERWRITE_ATTRIBUTE_KEY);
        if(map!=null){
            String host=map.get(OW_HOST);
            if(host!=null){
                return host;
            }
        }

        return getHeader(req, "host");
    }

    @Override
    public void destroy() {
        //do nothing
    }

    @Override
    protected String getRequestURI(HttpServletRequest req) {
        return req.getRequestURI();
    }

    @Override
    protected String getMethod(HttpServletRequest req) {
        return req.getMethod();
    }

    @Override
    protected String getQueryString(HttpServletRequest req) {
        return req.getQueryString();
    }

    @Override
    protected String getHeader(HttpServletRequest req, String key) {
        return req.getHeader(key);
    }

    @Override
    protected String getIpAddr(HttpServletRequest req) {
        return HttpRequestUtils.getIpAddr(req);
    }

    @Override
    protected void addAttribute(HttpServletRequest req, String key, Object value) {
        req.setAttribute(key, value);
    }

    @Override
    protected Object getAttribute(HttpServletRequest req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(HttpServletRequest req, String key) {
        return req.getParameter(key);
    }

    @Override
    protected List<String> getParameterNames(HttpServletRequest req) {
        return EnumerationUtils.toList(req.getParameterNames());
    }

    @Override
    protected int getStatus(HttpServletResponse resp) {
        return resp.getStatus();
    }

    @Override
    protected void addCookie(HttpServletResponse resp, String key, String value, String domain, String path) {
        Cookie cookie = new Cookie(key, value);
        if(domain != null){
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie(cookie);
    }

    @Override
    protected boolean isPerfTestRequest(HttpServletRequest req) {
        return PerfTestUtils.isPerfTestRequest(req);
    }

    @Override
    protected Map<String, String> getCookieMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        Map<String, String> cookieMap = new HashMap<>();
        if(cookies!=null){
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c.getValue());
            }
        }
        return cookieMap;
    }

    @Override
    public void setSelf(AccessLogFilter selfBean) {
        this.selfBean = selfBean;
    }
}
