package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import com.netflix.appinfo.EurekaInstanceConfig;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import javax.annotation.Resource;
import java.util.Collection;

/**
 * 注册一些额外的元数据到Eureka（Consul）中，比如服务器启动时间。
 */
@Configuration
@Import(CommonDiscoveryMetadataRegister.class)
//@AutoConfigureAfter(name = "org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration")
@ConditionalOnClass(EurekaInstanceConfig.class)
public class DiscoveryMetadataAutoConfiguration {
    //metadata中的key
    public static final String SERVER_START_UP_TIME_KEY = "serverStartUpTime";
    public static final String WEIGHT_KEY = "weight";
    //是否运行在spring jar in jar 模式下。
    public static final String RUN_IN_SINGLE_JAR_MODE = "runInSingleJarMode";
    public static final String DUIBA_BOOT_VERSION = "duibaBootVersion";
    public static final String SPRING_BOOT_VERSION = "springBootVersion";
    public static final String CONFIG_VERSION = "configVersion";
    //是否运行在Docker容器中(如果这个key设置在系统环境变量中，则key为 RUN_IN_DOCKER)
    public static final String RUN_IN_DOCKER = "run.in.docker";
    //压测场景id，如果eureka注册信息中包含此字段，表示这个容器只用于线上压测，正常流量不应该调度到这个容器，而且不同场景id之间流量也要隔离(如果这个key设置在系统环境变量中，则key为 DUIBA_PERF_SCENE_ID)
    //详情见此文档：  http://cf.dui88.com/pages/viewpage.action?pageId=10869508
    public static final String DUIBA_PERF_SCENE_ID = "duiba.perf.scene.id";

    //服务分组的id，目前用于支持容器组各种测试场景的分支独立需求
    public static final String DUIBA_SERVICE_GROUP_KEY = "duiba.service.group.key";

    @Bean
    public static SpecifiedBeanPostProcessor eurekaInstanceConfigBeanPostProcessor(){
        return new SpecifiedBeanPostProcessor<EurekaInstanceConfig>(){

            @Resource
            private ApplicationContext applicationContext;

            @Override
            public int getOrder() {
                return 0;
            }

            @Override
            public Class<EurekaInstanceConfig> getBeanType() {
                return EurekaInstanceConfig.class;
            }

            @Override
            public Object postProcessBeforeInitialization(EurekaInstanceConfig bean, String beanName) throws BeansException {
                return bean;
            }

            @Override
            public Object postProcessAfterInitialization(EurekaInstanceConfig bean, String beanName) throws BeansException {
                Collection<DiscoveryMetadataRegister> registers = applicationContext.getBeansOfType(DiscoveryMetadataRegister.class).values();

                if(registers != null) {
                    for (DiscoveryMetadataRegister register : registers) {
                        register.registerMetadata(bean.getMetadataMap());
                    }
                }

                return bean;
            }
        };
    }

}
