package cn.com.duibaboot.ext.autoconfigure.hazelcast;


import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.version.Version;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import java.util.Set;

/**
 * endpoint,可供查看hazelcast的集群状态、版本、集群成员等信息
 */
@Endpoint(id="hazelcast")
public class HazelcastEndpoint {

    private HazelcastInstance hazelcastInstance;

    public HazelcastEndpoint(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @ReadOperation
    public HazelcastEndpoint.HazelcastInfo getHazelcastInfo() {
        return HazelcastInfo.builder()
                .clusterVersion(hazelcastInstance.getCluster().getClusterVersion())
                .clusterState(hazelcastInstance.getCluster().getClusterState())
                .members(hazelcastInstance.getCluster().getMembers())
                .build();
    }

    @Getter
    @Setter
    @Builder
    static class HazelcastInfo{
        private Version clusterVersion;
        private ClusterState clusterState;
        private Set<Member> members;
    }
}
