package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

/**
 * 增加cat/DBTimeProfile监控耗时的功能
 */
public class ProfileCallable extends MonitorCallable {

    private String threadPoolName;

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue, String threadPoolName) {
        super(callable, queue);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Object call() throws Exception {
        DBTimeProfile.start();
        Callable callable = getRootCallable();
        String rootCallableClassName = callable.getClass().getName();
        try {
            return CatUtils.executeInCatTransaction(() -> super.call(),
                    "ThreadPool",
                    "(" + threadPoolName + ")" + rootCallableClassName);
        } catch (Throwable throwable) {
            throw Throwables.propagate(throwable);
        } finally{
            DBTimeProfile.end(rootCallableClassName + ", thread:" + Thread.currentThread().getName());
        }
    }

}
