package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.google.common.base.Throwables;

import java.util.concurrent.BlockingQueue;

/**
 * 增加cat/DBTimeProfile监控耗时的功能
 */
public class ProfileRunnable extends MonitorRunnable {

    private String threadPoolName = "undefined";

    public ProfileRunnable(Runnable runnable) {
        super(runnable);
    }

    public ProfileRunnable(Runnable runnable, BlockingQueue<Runnable> queue, String threadPoolName) {
        super(runnable, queue);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public void run() {
        DBTimeProfile.start();
        Runnable runnable = getRootRunnable();
        String rootRunnableClassName = runnable.getClass().getName();
        try {
            CatUtils.executeInCatTransaction(() -> {
                super.run();
                return null;
            }, "ThreadPool", "(" + threadPoolName + ")" + rootRunnableClassName);
        } catch (Throwable throwable) {
            throw Throwables.propagate(throwable);
        } finally{
            DBTimeProfile.end(rootRunnableClassName + ", thread:" + Thread.currentThread().getName());
        }
    }

}
