/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import cn.com.duiba.wolf.spring.selfaware.SelfAware;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import cn.com.duibaboot.ext.autoconfigure.core.utils.HttpRequestUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.EnumerationUtils;

public class AccessLogFilter
extends AbstractAccessLogFilter<HttpServletRequest, HttpServletResponse>
implements Filter,
SelfAware<AccessLogFilter> {
    @Deprecated
    private static final ThreadLocal<HttpServletRequest> requestThreadLocal = new ThreadLocal();
    public static final String OW_HOST = "host";
    private static volatile AccessLogFilter selfBean;

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        long start = System.currentTimeMillis();
        requestThreadLocal.set(req);
        try {
            this.doBefore(req, resp);
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            this.doAfter(req, resp, System.currentTimeMillis() - start);
            requestThreadLocal.remove();
        }
    }

    @Deprecated
    public static void putLogCookie(String key, String value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putLogCookie(req, key, value);
    }

    @Override
    protected Map<String, String> getLogCookie(HttpServletRequest req) {
        return (Map)req.getAttribute("_accesslog_log_cookie");
    }

    @Deprecated
    public static void setAppId(Long appId) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.setAppId(req, appId);
    }

    @Deprecated
    public static void setConsumerId(Long consumerId) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.setConsumerId(req, consumerId);
    }

    @Override
    public void setAppId(HttpServletRequest req, Long appId) {
        req.setAttribute("_accesslog_app_id", (Object)appId);
    }

    @Override
    public void setConsumerId(HttpServletRequest req, Long consumerId) {
        req.setAttribute("_accesslog_consumer_id", (Object)consumerId);
    }

    @Override
    protected Long getAppId(HttpServletRequest req) {
        Long appId = (Long)req.getAttribute("_accesslog_app_id");
        return appId;
    }

    @Override
    protected Long getConsumerId(HttpServletRequest req) {
        Long consumerId = (Long)req.getAttribute("_accesslog_consumer_id");
        return consumerId;
    }

    @Override
    public void putLogCookie(HttpServletRequest req, String key, String value) {
        HashMap<String, String> map = (HashMap<String, String>)req.getAttribute("_accesslog_log_cookie");
        if (map == null) {
            map = new HashMap<String, String>();
            req.setAttribute("_accesslog_log_cookie", map);
        }
        map.put(key, value);
    }

    @Override
    public void putExPair(HttpServletRequest req, String key, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)req.getAttribute("_accesslog_ex");
        if (map == null) {
            map = new HashMap<String, Object>();
            req.setAttribute("_accesslog_ex", map);
        }
        map.put(key, value);
    }

    @Override
    public void putOverWritePair(HttpServletRequest req, String key, String value) {
        HashMap<String, String> map = (HashMap<String, String>)req.getAttribute("_accesslog_overwrite");
        if (map == null) {
            map = new HashMap<String, String>();
            req.setAttribute("_accesslog_overwrite", map);
        }
        map.put(key, value);
    }

    @Deprecated
    public static void putExPair(String key, Object value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putExPair(req, key, value);
    }

    @Override
    protected Map<String, Object> getExPair(HttpServletRequest req) {
        return (Map)req.getAttribute("_accesslog_ex");
    }

    @Deprecated
    public static void putOverWritePair(String key, String value) {
        HttpServletRequest req = requestThreadLocal.get();
        selfBean.putOverWritePair(req, key, value);
    }

    @Override
    protected String getHost(HttpServletRequest req) {
        String host;
        Map map = (Map)req.getAttribute("_accesslog_overwrite");
        if (map != null && (host = (String)map.get(OW_HOST)) != null) {
            return host;
        }
        return this.getHeader(req, OW_HOST);
    }

    public void destroy() {
    }

    @Override
    protected String getRequestURI(HttpServletRequest req) {
        return req.getRequestURI();
    }

    @Override
    protected String getMethod(HttpServletRequest req) {
        return req.getMethod();
    }

    @Override
    protected String getQueryString(HttpServletRequest req) {
        return req.getQueryString();
    }

    @Override
    protected String getHeader(HttpServletRequest req, String key) {
        return req.getHeader(key);
    }

    @Override
    protected String getIpAddr(HttpServletRequest req) {
        return HttpRequestUtils.getIpAddr(req);
    }

    @Override
    protected void addAttribute(HttpServletRequest req, String key, Object value) {
        req.setAttribute(key, value);
    }

    @Override
    protected Object getAttribute(HttpServletRequest req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(HttpServletRequest req, String key) {
        return req.getParameter(key);
    }

    @Override
    protected List<String> getParameterNames(HttpServletRequest req) {
        return EnumerationUtils.toList((Enumeration)req.getParameterNames());
    }

    @Override
    protected int getStatus(HttpServletResponse resp) {
        return resp.getStatus();
    }

    @Override
    protected void addCookie(HttpServletResponse resp, String key, String value, String domain, String path) {
        Cookie cookie = new Cookie(key, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        resp.addCookie(cookie);
    }

    @Override
    protected boolean isPerfTestRequest(HttpServletRequest req) {
        return PerfTestUtils.isPerfTestRequest((HttpServletRequest)req);
    }

    @Override
    protected Map<String, String> getCookieMap(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        if (cookies != null) {
            for (Cookie c : cookies) {
                cookieMap.put(c.getName(), c.getValue());
            }
        }
        return cookieMap;
    }

    public void setSelf(AccessLogFilter selfBean) {
        AccessLogFilter.selfBean = selfBean;
    }
}

