/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.accesslog;

import cn.com.duiba.boot.perftest.ReactivePerfTestUtils;
import cn.com.duibaboot.ext.autoconfigure.accesslog.AbstractAccessLogFilter;
import cn.com.duibaboot.ext.autoconfigure.core.utils.ReactiveHttpRequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpCookie;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AccessLogReactiveFilter
extends AbstractAccessLogFilter<ServerWebExchange, ServerHttpResponse>
implements WebFilter {
    public static final String OW_HOST = "host";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        exchange.getRequest();
        long start = System.currentTimeMillis();
        this.doBefore(exchange, exchange.getResponse());
        return chain.filter(exchange).then(Mono.fromRunnable(() -> this.doAfter(exchange, exchange.getResponse(), System.currentTimeMillis() - start)));
    }

    @Override
    protected String getHost(ServerWebExchange req) {
        String host;
        Map map = (Map)req.getAttribute("_accesslog_overwrite");
        if (map != null && (host = (String)map.get(OW_HOST)) != null) {
            return host;
        }
        return this.getHeader(req, OW_HOST);
    }

    @Override
    protected String getRequestURI(ServerWebExchange req) {
        return req.getRequest().getURI().getPath();
    }

    @Override
    protected String getMethod(ServerWebExchange req) {
        return req.getRequest().getMethodValue();
    }

    @Override
    protected String getQueryString(ServerWebExchange req) {
        return req.getRequest().getURI().getQuery();
    }

    @Override
    protected String getHeader(ServerWebExchange req, String key) {
        return req.getRequest().getHeaders().getFirst(key);
    }

    @Override
    protected String getIpAddr(ServerWebExchange req) {
        return ReactiveHttpRequestUtils.getIpAddr(req.getRequest());
    }

    @Override
    protected void addAttribute(ServerWebExchange req, String key, Object value) {
        req.getAttributes().put(key, value);
    }

    @Override
    protected Object getAttribute(ServerWebExchange req, String key) {
        return req.getAttribute(key);
    }

    @Override
    protected String getParameter(ServerWebExchange req, String key) {
        return (String)req.getRequest().getQueryParams().getFirst((Object)key);
    }

    @Override
    protected List<String> getParameterNames(ServerWebExchange req) {
        MultiValueMap map = req.getRequest().getQueryParams();
        return new ArrayList<String>(map.keySet());
    }

    @Override
    protected int getStatus(ServerHttpResponse resp) {
        return resp.getStatusCode() == null ? 200 : resp.getStatusCode().value();
    }

    @Override
    protected void addCookie(ServerHttpResponse resp, String key, String value, String domain, String path) {
        ResponseCookie.ResponseCookieBuilder cookieBuilder = ResponseCookie.from((String)key, (String)value);
        if (domain != null) {
            cookieBuilder.domain(domain);
        }
        if (path != null) {
            cookieBuilder.path(path);
        }
        resp.addCookie(cookieBuilder.build());
    }

    @Override
    protected boolean isPerfTestRequest(ServerWebExchange req) {
        return ReactivePerfTestUtils.isPerfTestRequest((ServerHttpRequest)req.getRequest());
    }

    @Override
    protected Map<String, Object> getExPair(ServerWebExchange req) {
        return (Map)req.getAttribute("_accesslog_ex");
    }

    @Override
    protected Map<String, String> getCookieMap(ServerWebExchange req) {
        HashMap<String, String> ret = new HashMap<String, String>();
        MultiValueMap map = req.getRequest().getCookies();
        map.forEach((s, httpCookies) -> ret.put((String)s, ((HttpCookie)httpCookies.get(httpCookies.size() - 1)).getValue()));
        return ret;
    }

    @Override
    protected Map<String, String> getLogCookie(ServerWebExchange req) {
        return (Map)req.getAttribute("_accesslog_log_cookie");
    }

    @Override
    public void setAppId(ServerWebExchange req, Long appId) {
        req.getAttributes().put("_accesslog_app_id", appId);
    }

    @Override
    public void setConsumerId(ServerWebExchange req, Long consumerId) {
        req.getAttributes().put("_accesslog_consumer_id", consumerId);
    }

    @Override
    protected Long getAppId(ServerWebExchange req) {
        Long appId = (Long)req.getAttribute("_accesslog_app_id");
        return appId;
    }

    @Override
    protected Long getConsumerId(ServerWebExchange req) {
        Long consumerId = (Long)req.getAttribute("_accesslog_consumer_id");
        return consumerId;
    }

    @Override
    public void putLogCookie(ServerWebExchange req, String key, String value) {
        HashMap<String, String> map = (HashMap<String, String>)req.getAttribute("_accesslog_log_cookie");
        if (map == null) {
            map = new HashMap<String, String>();
            req.getAttributes().put("_accesslog_log_cookie", map);
        }
        map.put(key, value);
    }

    @Override
    public void putExPair(ServerWebExchange req, String key, Object value) {
        HashMap<String, Object> map = (HashMap<String, Object>)req.getAttribute("_accesslog_ex");
        if (map == null) {
            map = new HashMap<String, Object>();
            req.getAttributes().put("_accesslog_ex", map);
        }
        map.put(key, value);
    }

    @Override
    public void putOverWritePair(ServerWebExchange req, String key, String value) {
        HashMap<String, String> map = (HashMap<String, String>)req.getAttribute("_accesslog_overwrite");
        if (map == null) {
            map = new HashMap<String, String>();
            req.getAttributes().put("_accesslog_overwrite", map);
        }
        map.put(key, value);
    }
}

