/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import brave.Tracing;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnection;
import zipkin2.Endpoint;

@Aspect
@Order(value=-1)
public class SleuthSpringDataLettucePlugin {
    private static final Logger logger = LoggerFactory.getLogger(SleuthSpringDataLettucePlugin.class);
    @Autowired
    private Tracer tracer;
    @Autowired
    private Tracing tracing;
    @Autowired
    private ErrorParser errorParser;
    private volatile Class<?> lastRedisConnectionProxyClass;

    @Around(value="execution(* org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory.getConnection(..))")
    public Object springDataLettuceJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            try {
                RedisConnection connection = (RedisConnection)joinPoint.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget((Object)connection);
                factory.addAdvice((Advice)new RedisConnectionMethodInterceptor());
                RedisConnection newConnection = (RedisConnection)factory.getProxy();
                if (this.lastRedisConnectionProxyClass != null && this.lastRedisConnectionProxyClass != newConnection.getClass()) {
                    logger.error("JedisConnectionProxyClass is not same\uff0cthis is spring's bug,please upgrade spring-boot's version to 1.3.8.RELEASE or higher! {},{},{},{}", new Object[]{this.getClass().getClassLoader(), newConnection.getClass().getClassLoader(), this.lastRedisConnectionProxyClass, newConnection.getClass()});
                }
                this.lastRedisConnectionProxyClass = newConnection.getClass();
                return newConnection;
            }
            catch (Throwable e) {
                Span span = this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start();
                span.tag("redis.op", methodName);
                span.tag("lc", "springDataLettuce");
                this.errorParser.error(e, (SpanCustomizer)span);
                span.finish();
                throw e;
            }
        }
        return joinPoint.proceed();
    }

    private Object interceptorRedisMethods(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
            return invocation.proceed();
        }
        Span span = this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start();
        try {
            Object obj;
            span.tag("redis.op", methodName);
            span.tag("lc", "springDataLettuce");
            if ("get".equals(methodName) && invocation.getArguments() != null && invocation.getArguments().length == 1 && invocation.getArguments()[0] != null) {
                obj = invocation.getArguments()[0];
                if (obj instanceof byte[]) {
                    span.tag("redis.key", new String((byte[])obj));
                } else {
                    span.tag("redis.key", obj.toString());
                }
            }
            obj = invocation.proceed();
            return obj;
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private class LettuceAsyncMethodInterceptor
    implements MethodInterceptor {
        private LettuceAsyncMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (!invocation.getMethod().getReturnType().equals(RedisFuture.class)) {
                return invocation.proceed();
            }
            String methodName = invocation.getMethod().getName();
            Span curSpan = SleuthSpringDataLettucePlugin.this.tracer.currentSpan();
            if (curSpan == null || curSpan.isNoop()) {
                return invocation.proceed();
            }
            long startTimeMillis = SleuthSpringDataLettucePlugin.this.tracing.clock(curSpan.context()).currentTimeMicroseconds();
            RedisFuture future = (RedisFuture)invocation.proceed();
            future.whenComplete((s, throwable) -> {
                try (Tracer.SpanInScope ws = SleuthSpringDataLettucePlugin.this.tracer.withSpanInScope(curSpan);){
                    Span span = SleuthSpringDataLettucePlugin.this.tracer.nextSpan().name("redis:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("redis").build()).start(startTimeMillis);
                    span.tag("redis.op", methodName);
                    span.tag("lc", "springDataLettuce");
                    if ("get".equals(methodName) && invocation.getArguments() != null && invocation.getArguments().length == 1 && invocation.getArguments()[0] != null) {
                        Object obj = invocation.getArguments()[0];
                        if (obj instanceof byte[]) {
                            span.tag("redis.key", new String((byte[])obj));
                        } else {
                            span.tag("redis.key", obj.toString());
                        }
                    }
                    if (throwable != null) {
                        SleuthSpringDataLettucePlugin.this.errorParser.error((Throwable)throwable, (SpanCustomizer)span);
                    }
                    span.finish();
                }
            });
            return future;
        }
    }

    private class RedisConnectionMethodInterceptor
    implements MethodInterceptor {
        RedisConnectionMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing") || methodName.equals("isClosed") || methodName.equals("close") || methodName.equals("closePipeline") || methodName.endsWith("Commands")) {
                return invocation.proceed();
            }
            if (methodName.equals("getNativeConnection")) {
                Object nativeConnection;
                Object newNativeConnection = nativeConnection = invocation.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget(nativeConnection);
                if (nativeConnection instanceof RedisClusterAsyncCommands) {
                    factory.addAdvice((Advice)new LettuceAsyncMethodInterceptor());
                    newNativeConnection = factory.getProxy();
                }
                return newNativeConnection;
            }
            return SleuthSpringDataLettucePlugin.this.interceptorRedisMethods(invocation);
        }
    }
}

