/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.rx;

import java.io.IOException;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class ResponseBodyEmitterSubscriber<T>
extends Subscriber<T>
implements Runnable {
    private final MediaType mediaType;
    private final Subscription subscription;
    private final ResponseBodyEmitter responseBodyEmitter;
    private boolean completed;

    public ResponseBodyEmitterSubscriber(MediaType mediaType, Observable<T> observable, ResponseBodyEmitter responseBodyEmitter) {
        this.mediaType = mediaType;
        this.responseBodyEmitter = responseBodyEmitter;
        this.responseBodyEmitter.onTimeout((Runnable)this);
        this.responseBodyEmitter.onCompletion((Runnable)this);
        this.subscription = observable.subscribe((Subscriber)this);
    }

    public void onNext(T value) {
        try {
            if (!this.completed) {
                this.responseBodyEmitter.send(value, this.mediaType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void onError(Throwable e) {
        this.responseBodyEmitter.completeWithError(e);
    }

    public void onCompleted() {
        if (!this.completed) {
            this.completed = true;
            this.responseBodyEmitter.complete();
        }
    }

    @Override
    public void run() {
        this.subscription.unsubscribe();
    }
}

