/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.hazelcast;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.version.Version;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="hazelcast")
public class HazelcastEndpoint {
    private HazelcastInstance hazelcastInstance;

    public HazelcastEndpoint(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @ReadOperation
    public HazelcastInfo getHazelcastInfo() {
        return HazelcastInfo.builder().clusterVersion(this.hazelcastInstance.getCluster().getClusterVersion()).clusterState(this.hazelcastInstance.getCluster().getClusterState()).members(this.hazelcastInstance.getCluster().getMembers()).build();
    }

    static class HazelcastInfo {
        private Version clusterVersion;
        private ClusterState clusterState;
        private Set<Member> members;

        HazelcastInfo(Version clusterVersion, ClusterState clusterState, Set<Member> members) {
            this.clusterVersion = clusterVersion;
            this.clusterState = clusterState;
            this.members = members;
        }

        public static HazelcastInfoBuilder builder() {
            return new HazelcastInfoBuilder();
        }

        public Version getClusterVersion() {
            return this.clusterVersion;
        }

        public ClusterState getClusterState() {
            return this.clusterState;
        }

        public Set<Member> getMembers() {
            return this.members;
        }

        public void setClusterVersion(Version clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public void setClusterState(ClusterState clusterState) {
            this.clusterState = clusterState;
        }

        public void setMembers(Set<Member> members) {
            this.members = members;
        }

        public static class HazelcastInfoBuilder {
            private Version clusterVersion;
            private ClusterState clusterState;
            private Set<Member> members;

            HazelcastInfoBuilder() {
            }

            public HazelcastInfoBuilder clusterVersion(Version clusterVersion) {
                this.clusterVersion = clusterVersion;
                return this;
            }

            public HazelcastInfoBuilder clusterState(ClusterState clusterState) {
                this.clusterState = clusterState;
                return this;
            }

            public HazelcastInfoBuilder members(Set<Member> members) {
                this.members = members;
                return this;
            }

            public HazelcastInfo build() {
                return new HazelcastInfo(this.clusterVersion, this.clusterState, this.members);
            }

            public String toString() {
                return "HazelcastEndpoint.HazelcastInfo.HazelcastInfoBuilder(clusterVersion=" + this.clusterVersion + ", clusterState=" + this.clusterState + ", members=" + this.members + ")";
            }
        }
    }
}

