/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.threadpool.proxy.MonitorCallable;
import com.google.common.base.Throwables;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;

public class ProfileCallable
extends MonitorCallable {
    private String threadPoolName;

    public ProfileCallable(Callable callable) {
        super(callable);
    }

    public ProfileCallable(Callable callable, BlockingQueue<Runnable> queue, String threadPoolName) {
        super(callable, queue);
        this.threadPoolName = threadPoolName;
    }

    @Override
    public Object call() throws Exception {
        DBTimeProfile.start();
        Callable callable = this.getRootCallable();
        String rootCallableClassName = callable.getClass().getName();
        try {
            Object object = CatUtils.executeInCatTransaction(() -> super.call(), "ThreadPool", "(" + this.threadPoolName + ")" + rootCallableClassName);
            return object;
        }
        catch (Throwable throwable) {
            throw Throwables.propagate((Throwable)throwable);
        }
        finally {
            DBTimeProfile.end((String)(rootCallableClassName + ", thread:" + Thread.currentThread().getName()));
        }
    }
}

