package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.Span;
import brave.Tracer;
import brave.propagation.ExtraFieldPropagation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebProperties;
import org.springframework.cloud.sleuth.instrument.web.TraceWebServletAutoConfiguration;
import org.springframework.core.annotation.Order;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Pattern;

@Order(TraceWebServletAutoConfiguration.TRACING_FILTER_ORDER+1)
public class DuibaTraceSecondFilter implements Filter {

    private Pattern skipPattern = Pattern.compile(SleuthWebProperties.DEFAULT_SKIP_PATTERN);

    private static Tracer tracer;

    @Autowired
    public void setTracer(Tracer tracer) {
        DuibaTraceSecondFilter.tracer = tracer;//NOSONAR
    }

    @Override
    public void init(FilterConfig filterConfig){
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            throw new ServletException("Filter just supports HTTP requests");
        }

        HttpServletRequest httpRequest = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        boolean skip = skipPattern.matcher(httpRequest.getRequestURI()).matches();
        if (!skip) {
            Span span = tracer.currentSpan();
            String bagFlages = ExtraFieldPropagation.get(span.context(), ZipkinConstants.SPAN_FLAGS);
            String flages = (String) Optional.ofNullable(servletRequest.getAttribute(ZipkinConstants.SPAN_FLAGS)).orElse(ZipkinConstants.SPAN_NOT_SAMPLED);
            if(StringUtils.equalsIgnoreCase(ZipkinConstants.SPAN_SAMPLED,flages)||StringUtils.equalsIgnoreCase(ZipkinConstants.SPAN_SAMPLED,bagFlages)){
                ExtraFieldPropagation.set(span.context(), ZipkinConstants.SPAN_FLAGS, ZipkinConstants.SPAN_SAMPLED);
                response.setHeader(ZipkinConstants.TRACE_ID_NAME,span.context().traceIdString());
            }
        }
        chain.doFilter(servletRequest, servletResponse);
    }

    @Override
    public void destroy() {
        //do nothing
    }

    protected static Boolean isDebugMode(){
        if(tracer==null || tracer.currentSpan() == null){
            return false;
        }
        Span span = tracer.currentSpan();
        String bagFlages = ExtraFieldPropagation.get(span.context(), ZipkinConstants.SPAN_FLAGS);
        return StringUtils.equalsIgnoreCase(ZipkinConstants.SPAN_SAMPLED,bagFlages);
    }

}
