/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import com.dianping.cat.Cat;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.DefaultTransaction;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.redis.connection.RedisConnection;

@Aspect
public class CatSpringDataLettucePlugin {
    private static final Logger logger = LoggerFactory.getLogger(CatSpringDataLettucePlugin.class);

    @Around(value="execution(* org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if (CatUtils.isCatEnabled() && "getConnection".equals(methodName)) {
            try {
                RedisConnection connection = (RedisConnection)joinPoint.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget((Object)connection);
                factory.addAdvice((Advice)new RedisConnectionMethodInterceptor());
                RedisConnection newConnection = (RedisConnection)factory.getProxy();
                return newConnection;
            }
            catch (Throwable e) {
                Transaction transaction = Cat.newTransaction((String)"Cache.dataRedis.Lettuce", (String)methodName);
                Cat.logError((Throwable)e);
                transaction.setStatus(e);
                transaction.complete();
                throw e;
            }
        }
        return joinPoint.proceed();
    }

    private static Object interceptorRedisMethods(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("toString") || methodName.equals("hashCode") || methodName.equals("equals")) {
            return invocation.proceed();
        }
        Transaction transaction = "get".equals(methodName) ? Cat.newTransaction((String)"Cache.dataRedis.Lettuce", (String)(methodName + ":" + methodName)) : Cat.newTransaction((String)"Cache.dataRedis.Lettuce", (String)methodName);
        try {
            Object value = invocation.proceed();
            if (value == null && "get".equals(methodName)) {
                Cat.logEvent((String)"Cache.dataRedis.Lettuce", (String)(methodName + ":missed"));
            }
            transaction.setStatus("0");
            Object object = value;
            return object;
        }
        catch (Throwable e) {
            Cat.logError((Throwable)e);
            transaction.setStatus(e);
            throw e;
        }
        finally {
            transaction.complete();
        }
    }

    private static class LettuceAsyncMethodInterceptor
    implements MethodInterceptor {
        private LettuceAsyncMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (!invocation.getMethod().getReturnType().equals(RedisFuture.class)) {
                return invocation.proceed();
            }
            String methodName = invocation.getMethod().getName();
            long startTime = System.nanoTime();
            RedisFuture future = (RedisFuture)invocation.proceed();
            future.whenComplete((s, throwable) -> {
                Transaction transaction = "get".equals(methodName) ? Cat.newTransaction((String)"Cache.dataRedis.Lettuce", (String)(methodName + ":" + methodName)) : Cat.newTransaction((String)"Cache.dataRedis.Lettuce", (String)methodName);
                ((DefaultTransaction)transaction).setDurationStart(startTime);
                if (throwable != null) {
                    Cat.logError((Throwable)((Throwable)throwable));
                    transaction.setStatus((Throwable)throwable);
                } else {
                    if (s != null && "get".equals(methodName)) {
                        Cat.logEvent((String)"Cache.dataRedis.Lettuce", (String)(methodName + ":missed"));
                    }
                    transaction.setStatus("0");
                }
                transaction.complete();
            });
            return future;
        }
    }

    private static class RedisConnectionMethodInterceptor
    implements MethodInterceptor {
        RedisConnectionMethodInterceptor() {
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if (methodName.equals("isPipelined") || methodName.equals("openPipeline") || methodName.equals("isQueueing") || methodName.equals("isClosed") || methodName.equals("close") || methodName.equals("closePipeline") || methodName.endsWith("Commands")) {
                return invocation.proceed();
            }
            if (methodName.equals("getNativeConnection")) {
                Object nativeConnection;
                Object newNativeConnection = nativeConnection = invocation.proceed();
                ProxyFactory factory = new ProxyFactory();
                factory.setTarget(nativeConnection);
                if (nativeConnection instanceof RedisClusterAsyncCommands) {
                    factory.addAdvice((Advice)new LettuceAsyncMethodInterceptor());
                    newNativeConnection = factory.getProxy();
                }
                return newNativeConnection;
            }
            return CatSpringDataLettucePlugin.interceptorRedisMethods(invocation);
        }
    }
}

