/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.SpanCustomizer;
import brave.Tracer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import zipkin2.Endpoint;

@Aspect
public class SleuthElasticSearchPlugin {
    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    @Around(value="execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        Span curSpan = this.tracer.currentSpan();
        if (curSpan == null || curSpan.isNoop()) {
            return joinPoint.proceed();
        }
        Span span = this.tracer.nextSpan().name("elasticsearch:/" + methodName).kind(Span.Kind.CLIENT).remoteEndpoint(Endpoint.newBuilder().serviceName("Elasticsearch").build()).start();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ElasticsearchOperations").append(".").append(methodName);
        try {
            span.tag("elasticsearch.class_method", stringBuilder.toString());
            span.tag("lc", "ElasticsearchTemplate");
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            this.errorParser.error((Throwable)e, (SpanCustomizer)span);
            throw e;
        }
        finally {
            span.finish();
        }
    }
}

