/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.cloud.zipkin;

import brave.sampler.Sampler;
import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;

public class PercentageBasedSampler
extends Sampler {
    private final AtomicInteger counter = new AtomicInteger(0);
    private final BitSet sampleDecisions;
    private final SamplerProperties configuration;

    public PercentageBasedSampler(SamplerProperties configuration) {
        int outOf10000 = (int)(configuration.getProbability() * 10000.0f);
        this.sampleDecisions = PercentageBasedSampler.randomBitSet(10000, outOf10000, new Random());
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSampled(long traceId) {
        if (this.configuration.getProbability() == 0.0f) {
            return false;
        }
        if (this.configuration.getProbability() == 1.0f) {
            return true;
        }
        PercentageBasedSampler percentageBasedSampler = this;
        synchronized (percentageBasedSampler) {
            int i = this.counter.getAndIncrement();
            boolean result = this.sampleDecisions.get(i);
            if (i == 9999) {
                this.counter.set(0);
            }
            return result;
        }
    }

    static BitSet randomBitSet(int size, int cardinality, Random rnd) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        while (i < size) {
            int j = rnd.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }
}

