/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.datasource;

import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DatabaseDriver;

@ConfigurationProperties(value="duiba")
public class DuibaDataSourceProperties {
    public static final String DUIBA_DATA_SOURCE_PROPERTIES_PREFIX = "duiba";
    private Map<String, DataSourcePropertiesInner> datasource = new LinkedHashMap<String, DataSourcePropertiesInner>();

    public Map<String, DataSourcePropertiesInner> getDatasource() {
        return this.datasource;
    }

    public void setDatasource(Map<String, DataSourcePropertiesInner> datasource) {
        this.datasource = datasource;
    }

    public static class DataSourcePropertiesInner {
        private static final Logger logger = LoggerFactory.getLogger(DataSourcePropertiesInner.class);
        private static final Class<?> DBCP2_CLASS;
        private String url;
        private String username;
        private String password;
        private Integer maxTotal = 8;
        private Integer initialSize = 3;
        private Integer maxIdle = 8;
        private Integer minIdle = 0;
        private Integer maxWaitMillis = 3000;
        private List<String> connectionInitSqls = new ArrayList<String>();

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Integer getMaxTotal() {
            return this.maxTotal;
        }

        public void setMaxTotal(Integer maxTotal) {
            this.maxTotal = maxTotal;
        }

        public Integer getInitialSize() {
            return this.initialSize;
        }

        public void setInitialSize(Integer initialSize) {
            this.initialSize = initialSize;
        }

        public Integer getMaxIdle() {
            return this.maxIdle;
        }

        public void setMaxIdle(Integer maxIdle) {
            this.maxIdle = maxIdle;
        }

        public Integer getMinIdle() {
            return this.minIdle;
        }

        public void setMinIdle(Integer minIdle) {
            this.minIdle = minIdle;
        }

        public Integer getMaxWaitMillis() {
            return this.maxWaitMillis;
        }

        public void setMaxWaitMillis(Integer maxWaitMillis) {
            this.maxWaitMillis = maxWaitMillis;
        }

        public Class<? extends DataSource> getType() {
            try {
                Class.forName("org.apache.commons.dbcp2.BasicDataSource");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("\u68c0\u6d4b\u5230\u4f60\u7684\u9879\u76ee\u4e2d\u9700\u8981\u4f7f\u7528dataSource\uff0c\u76ee\u524d\u5f3a\u5236\u4f7f\u7528dbcp2\uff0c\u8bf7\u5f15\u5165dbcp2 \u7684jar\u4f9d\u8d56.");
            }
            return BasicDataSource.class;
        }

        public String determineDriverClassName() {
            String driverClassName = null;
            if (org.springframework.util.StringUtils.hasText((String)this.url)) {
                if (this.url.startsWith("jdbc:mysql:")) {
                    driverClassName = "com.mysql.jdbc.Driver";
                } else {
                    driverClassName = DatabaseDriver.fromJdbcUrl((String)this.url).getDriverClassName();
                    if (driverClassName == null && this.url.startsWith("jdbc:phoenix:")) {
                        driverClassName = "org.apache.phoenix.jdbc.PhoenixDriver";
                    }
                }
            }
            if (!org.springframework.util.StringUtils.hasText(driverClassName)) {
                throw new IllegalStateException("can't determine driverClassName of url:" + this.url);
            }
            return driverClassName;
        }

        public BeanDefinitionBuilder initializeDataSourceBeanDefinitionBuilder() {
            if (org.springframework.util.StringUtils.isEmpty((Object)this.url)) {
                return null;
            }
            Class<? extends DataSource> dataSourceClass = this.getType();
            if (DBCP2_CLASS != null && DBCP2_CLASS.isAssignableFrom(dataSourceClass)) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(dataSourceClass).addPropertyValue("driverClassName", (Object)this.determineDriverClassName()).addPropertyValue("url", (Object)this.getUrl()).addPropertyValue("initialSize", (Object)this.initialSize).addPropertyValue("maxTotal", (Object)this.maxTotal).addPropertyValue("minIdle", (Object)this.minIdle).addPropertyValue("maxIdle", (Object)this.maxIdle).addPropertyValue("maxWaitMillis", (Object)this.maxWaitMillis).setDestroyMethodName("close");
                if (!StringUtils.isBlank((CharSequence)this.getUsername())) {
                    builder.addPropertyValue("username", (Object)this.getUsername());
                }
                if (!StringUtils.isBlank((CharSequence)this.getPassword())) {
                    builder.addPropertyValue("password", (Object)this.getPassword());
                }
                builder.addPropertyValue("connectionInitSqls", this.getConnectionInitSqls());
                return builder;
            }
            throw new IllegalStateException("unsupportted dataSource type:" + dataSourceClass.getName() + ", currently only dbcp2 is supported");
        }

        public void bindProperties(String dataSourceBeanName, DataSource dataSource) {
            ArrayList<Object> dataSourcesNeedChange = new ArrayList<Object>();
            if (dataSource instanceof PerfTestRoutingDataSource) {
                PerfTestRoutingDataSource ds1 = (PerfTestRoutingDataSource)((Object)dataSource);
                dataSourcesNeedChange.add(ds1.getOriginalDataSource());
                if (ds1.getShadeDataSource() != null) {
                    dataSourcesNeedChange.add(ds1.getShadeDataSource());
                }
            } else {
                dataSourcesNeedChange.add(dataSource);
            }
            for (DataSource dataSource2 : dataSourcesNeedChange) {
                if (DBCP2_CLASS != null && DBCP2_CLASS.isAssignableFrom(dataSource2.getClass())) {
                    BasicDataSource d = (BasicDataSource)dataSource2;
                    d.setUrl(this.getUrl());
                    d.setUsername(this.getUsername());
                    d.setPassword(this.getPassword());
                    d.setInitialSize(this.initialSize.intValue());
                    d.setMaxTotal(this.maxTotal.intValue());
                    d.setMinIdle(this.minIdle.intValue());
                    d.setMaxIdle(this.maxIdle.intValue());
                    d.setMaxWaitMillis((long)this.maxWaitMillis.intValue());
                    continue;
                }
                logger.warn("\u4e0d\u80fd\u5237\u65b0\u6570\u636e\u6e90\u7c7b\u578b\uff1a{}, beanId:{}\uff0c\u5f53\u524d\u53ea\u652f\u6301\u5237\u65b0dbcp2\u6570\u636e\u6e90", (Object)dataSource2.getClass().getName(), (Object)dataSourceBeanName);
            }
        }

        public List<String> getConnectionInitSqls() {
            return this.connectionInitSqls;
        }

        public void setConnectionInitSqls(List<String> connectionInitSqls) {
            this.connectionInitSqls = connectionInitSqls;
        }

        static {
            Class<?> dbcp2Class = null;
            try {
                dbcp2Class = Class.forName("org.apache.commons.dbcp2.BasicDataSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            DBCP2_CLASS = dbcp2Class;
        }
    }
}

