/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.grouping;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceGroupUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceGroupUtils.class);
    public static final String DUIBA_SERVICE_GROUP_KEY = "_duibaServiceGroupKey";

    private ServiceGroupUtils() {
    }

    public static String getDuibaServiceGroupKey(HttpServletRequest request) {
        String groupKey = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!DUIBA_SERVICE_GROUP_KEY.equals(cookie.getName())) continue;
                groupKey = cookie.getValue();
            }
        }
        if (StringUtils.isBlank(groupKey)) {
            groupKey = request.getHeader(DUIBA_SERVICE_GROUP_KEY);
        }
        return groupKey;
    }
}

