/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.logger;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.DuibaEurekaAutoServiceRegistration;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.ribbon.RibbonCustomAutoConfiguration;
import cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils;
import cn.com.duibaboot.ext.autoconfigure.logger.NonRefreshLogbackLoggingSystem;
import cn.com.duibaboot.ext.autoconfigure.logger.filter.CatLoggerCountFilter;
import cn.com.duibaboot.ext.autoconfigure.logger.filter.LoggerSizeFilter;
import cn.com.duibaboot.ext.autoconfigure.logger.logback.appender.KafkaAppender;
import cn.com.duibaboot.ext.autoconfigure.logger.logback.appender.KafkaAppenderProperties;
import cn.com.duibaboot.ext.autoconfigure.perftest.PerfTestRoutingDataSource;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.diagnostics.LoggingFailureAnalysisReporter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.kafka.core.KafkaTemplate;

@Configuration
@ConditionalOnClass(value={LoggerContext.class})
public class LoggerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(LoggerAutoConfiguration.class);

    @Bean
    public ApplicationListener duibaLogbackFlusher() {
        return new DuibaLogbackFlusher();
    }

    @Bean
    public ApplicationListener loggerLevelChangerApplicationListener() {
        return new ApplicationListener<ContextRefreshedEvent>(){
            private boolean flag = true;
            private Map<String, String> loggerNames = Maps.newHashMap();
            {
                this.loggerNames.put("org.springframework.boot.actuate.health", "WARN");
                this.loggerNames.put("org.springframework.cloud", "WARN");
                this.loggerNames.put(LoggingFailureAnalysisReporter.class.getName(), "DEBUG");
                this.loggerNames.put(DuibaEurekaAutoServiceRegistration.class.getName(), "INFO");
                this.loggerNames.put(RibbonCustomAutoConfiguration.class.getName(), "INFO");
                this.loggerNames.put("io.lettuce", "INFO");
            }

            public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
                if (this.flag) {
                    for (Map.Entry<String, String> entry : this.loggerNames.entrySet()) {
                        ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)entry.getKey());
                        logger.setLevel(Level.toLevel((String)entry.getValue()));
                    }
                    this.flag = false;
                }
            }
        };
    }

    @Bean
    public ApplicationListener asyncLoggerConfiguar() {
        return new AsyncLoggerConfiguarListener();
    }

    @Bean
    public LoggerSizeFilter loggerSizeFilter() {
        return new LoggerSizeFilter();
    }

    @EventListener(value={ContextRefreshedEvent.class, ContextClosedEvent.class})
    public void onEvent(ApplicationContextEvent e) {
        if (e instanceof ContextRefreshedEvent) {
            NonRefreshLogbackLoggingSystem.setCanCleanUp(false);
        } else if (e instanceof ContextClosedEvent) {
            NonRefreshLogbackLoggingSystem.setCanCleanUp(true);
        }
    }

    @Configuration
    @ConditionalOnClass(value={KafkaTemplate.class})
    @EnableConfigurationProperties(value={KafkaAppenderProperties.class})
    public static class KafkaAppenderConfiguration {
        @Autowired
        private KafkaAppenderProperties kafkaAppenderProperties;
        @Autowired
        private KafkaTemplate kafkaTemplate;
        private boolean flag = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventListener(value={ContextRefreshedEvent.class})
        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!this.flag) {
                return;
            }
            try {
                if (this.kafkaAppenderProperties.getPatterns() == null || this.kafkaAppenderProperties.getPatterns().length == 0) {
                    return;
                }
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                ArrayListMultimap logger2PatternsMap = ArrayListMultimap.create();
                for (KafkaAppenderProperties.Pattern pattern : this.kafkaAppenderProperties.getPatterns()) {
                    if (StringUtils.isBlank((CharSequence)pattern.getLoggerName())) {
                        throw new IllegalStateException("config `duiba.logback.appender.kafka[*].logger-name` must not be blank");
                    }
                    if (StringUtils.isBlank((CharSequence)pattern.getTopic())) {
                        throw new IllegalStateException("config `duiba.logback.appender.kafka[*].topic` must not be blank");
                    }
                    logger2PatternsMap.put((Object)pattern.getLoggerName(), (Object)pattern);
                }
                for (String loggerName : logger2PatternsMap.keySet()) {
                    Collection patterns = logger2PatternsMap.get((Object)loggerName);
                    if (CollectionUtils.isEmpty((Collection)patterns)) continue;
                    ch.qos.logback.classic.Logger logger = loggerContext.getLogger(loggerName);
                    KafkaAppender appender = new KafkaAppender(this.kafkaTemplate, patterns);
                    appender.setContext((Context)loggerContext);
                    appender.start();
                    logger.addAppender(appender);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.flag = false;
            }
        }
    }

    private static class AsyncLoggerConfiguarListener
    implements ApplicationListener<ContextRefreshedEvent> {
        private boolean flag = true;
        private Map<FileAppender, AsyncAppender> syncAppender2asyncAppenderCachedMap = new HashMap<FileAppender, AsyncAppender>();
        private Set<FileAppender> fileAppenders = Sets.newHashSet();
        @Resource
        LoggerSizeFilter loggerSizeFilter;

        private AsyncLoggerConfiguarListener() {
        }

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!this.flag) {
                return;
            }
            try {
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                List loggers = loggerContext.getLoggerList();
                for (ch.qos.logback.classic.Logger logger : loggers) {
                    this.switchLogAppend2Async(logger);
                }
                if (CatUtils.isCatClassExists()) {
                    for (FileAppender fileAppender : this.fileAppenders) {
                        fileAppender.addFilter((Filter)new CatLoggerCountFilter(fileAppender.getFile()));
                    }
                }
                for (FileAppender fileAppender : this.fileAppenders) {
                    fileAppender.addFilter((Filter)this.loggerSizeFilter);
                }
                this.syncAppender2asyncAppenderCachedMap = null;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.flag = false;
        }

        private void switchLogAppend2Async(ch.qos.logback.classic.Logger log) {
            Iterator iter = log.iteratorForAppenders();
            ArrayList<AsyncAppender> asyncAppenders2Add = new ArrayList<AsyncAppender>();
            ArrayList<Appender> appenders2Remove = new ArrayList<Appender>();
            while (iter.hasNext()) {
                Appender appender = (Appender)iter.next();
                if (appender instanceof FileAppender) {
                    FileAppender fileAppender = (FileAppender)appender;
                    AsyncAppender asyncAppender = this.getCachedAsyncAppender(fileAppender);
                    asyncAppenders2Add.add(asyncAppender);
                    appenders2Remove.add(appender);
                    this.fileAppenders.add(fileAppender);
                }
                if (!(appender instanceof AsyncAppender)) continue;
                Iterator iterator = ((AsyncAppender)appender).iteratorForAppenders();
                while (iterator.hasNext()) {
                    Appender childAsyncAppender = (Appender)iterator.next();
                    if (!(childAsyncAppender instanceof FileAppender)) continue;
                    this.fileAppenders.add((FileAppender)childAsyncAppender);
                }
            }
            for (Appender appender : appenders2Remove) {
                log.detachAppender(appender);
            }
            for (Appender appender : asyncAppenders2Add) {
                log.addAppender(appender);
            }
        }

        private AsyncAppender getCachedAsyncAppender(FileAppender fileAppender) {
            AsyncAppender asyncAppender = this.syncAppender2asyncAppenderCachedMap.get(fileAppender);
            if (asyncAppender == null) {
                asyncAppender = new AsyncAppender();
                asyncAppender.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
                asyncAppender.setDiscardingThreshold(0);
                asyncAppender.setQueueSize(512);
                boolean includeCallerData = false;
                Encoder encoder = fileAppender.getEncoder();
                if (encoder != null && encoder instanceof PatternLayoutEncoderBase) {
                    PatternLayoutEncoderBase pencoder = (PatternLayoutEncoderBase)encoder;
                    String pattern = pencoder.getPattern();
                    if (pattern.contains("%L") || pattern.contains("%line") || pattern.contains("%C") || pattern.contains("%class") || pattern.contains("%M") || pattern.contains("%method") || pattern.contains("%F") || pattern.contains("%file") || pattern.contains("%caller")) {
                        includeCallerData = true;
                    }
                    pencoder.setImmediateFlush(false);
                }
                asyncAppender.setIncludeCallerData(includeCallerData);
                asyncAppender.setName("DuibaBootAutoAsync_" + fileAppender.getName());
                asyncAppender.addAppender((Appender)fileAppender);
                asyncAppender.start();
                this.syncAppender2asyncAppenderCachedMap.put(fileAppender, asyncAppender);
            }
            return asyncAppender;
        }
    }

    private static class DuibaLogbackFlusher
    implements ApplicationListener<ContextRefreshedEvent> {
        private Timer timer = new Timer("logback-flusher");
        private Set<FileAppender> fileAppendersNeedFlush = Collections.synchronizedSet(new HashSet());
        private static final int intevalPeriod = 5000;
        private static final int timeDelay = 5000;
        private boolean flag = true;
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                fileAppendersNeedFlush.stream().map(fileAppender -> fileAppender.getOutputStream()).filter(o -> o != null).forEach(outputStream -> {
                    try {
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                });
            }
        };

        private DuibaLogbackFlusher() {
        }

        public void onApplicationEvent(ContextRefreshedEvent applicationStartedEvent) {
            if (!this.flag) {
                return;
            }
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            List loggers = loggerContext.getLoggerList();
            for (ch.qos.logback.classic.Logger logger : loggers) {
                Iterator iter = logger.iteratorForAppenders();
                while (iter.hasNext()) {
                    AsyncAppender asyncAppender;
                    Iterator iteratorForAppenders;
                    Appender appender = (Appender)iter.next();
                    if (appender instanceof AsyncAppender && (iteratorForAppenders = (asyncAppender = (AsyncAppender)appender).iteratorForAppenders()).hasNext()) {
                        appender = (Appender)iteratorForAppenders.next();
                    }
                    if (!(appender instanceof FileAppender)) continue;
                    FileAppender fileAppender = (FileAppender)appender;
                    this.fileAppendersNeedFlush.add(fileAppender);
                }
            }
            this.timer.schedule(this.timerTask, 5000L, 5000L);
            this.flag = false;
        }
    }

    @Configuration
    @ConditionalOnClass(value={BasicDataSource.class, LoggerContext.class, AbstractRoutingDataSource.class})
    public static class DataSourceMonitorConfigurer {
        @Bean(name={"_dataSourceMonitor"})
        public DataSourceMonitor _dataSourceMonitor() {
            return new DataSourceMonitor();
        }

        @Bean
        public ApplicationListener<MainContextRefreshedEvent> dataSourceMonitor() {
            return new ApplicationListener<MainContextRefreshedEvent>(){

                public void onApplicationEvent(MainContextRefreshedEvent event) {
                    ApplicationContext context = event.getApplicationContext();
                    DataSourceMonitor dataSourceMonitor = (DataSourceMonitor)context.getBean("_dataSourceMonitor", DataSourceMonitor.class);
                    dataSourceMonitor.startMonitorThread(context);
                }
            };
        }

        private static class DataSourceMonitor
        implements DisposableBean {
            private boolean initted = false;
            private Map<String, BasicDataSource> dataSourceMap;
            private Map<String, PerfTestRoutingDataSource> routingdataSourceMap;
            private Thread dataSourceMonitorThread;

            private DataSourceMonitor() {
            }

            public synchronized void startMonitorThread(ApplicationContext context) {
                if (!this.initted) {
                    this.initted = true;
                    this.dataSourceMap = context.getBeansOfType(BasicDataSource.class);
                    this.routingdataSourceMap = context.getBeansOfType(PerfTestRoutingDataSource.class);
                    if (this.dataSourceMap.isEmpty() && this.routingdataSourceMap.isEmpty()) {
                        return;
                    }
                    this.dataSourceMonitorThread = new Thread(() -> this.scanDataSources(), "dataSourceMonitorThread");
                    this.dataSourceMonitorThread.start();
                }
            }

            private void scanDataSources() {
                do {
                    for (Map.Entry<String, BasicDataSource> entry : this.dataSourceMap.entrySet()) {
                        this.scanDataSource(entry.getKey(), entry.getValue());
                    }
                    for (Map.Entry<String, Object> entry : this.routingdataSourceMap.entrySet()) {
                        this.scanDataSource(entry.getKey() + "_original", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getOriginalDataSource());
                        this.scanDataSource(entry.getKey() + "_shade", ((PerfTestRoutingDataSource)((Object)entry.getValue())).getShadeDataSource());
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } while (!Thread.currentThread().isInterrupted());
            }

            private void scanDataSource(String key, BasicDataSource ds) {
                if (ds != null && !ds.isClosed()) {
                    int numIdleConnections = ds.getNumIdle();
                    int numBusyConnections = ds.getNumActive();
                    int numConnections = numBusyConnections + numIdleConnections;
                    int max = ds.getMaxTotal();
                    if (numBusyConnections >= 3 && numConnections >= max - 3 && numBusyConnections >= numConnections - 3) {
                        logger.error("datasource [" + key + "]'s connectionPool is too full,max:" + max + ",busy:" + numBusyConnections + ",idle:" + numIdleConnections);
                    }
                }
            }

            public synchronized void destroy() throws Exception {
                if (this.dataSourceMonitorThread != null) {
                    this.dataSourceMonitorThread.interrupt();
                }
            }
        }
    }
}

