/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.security.dpefensivepolicy;

import cn.com.duibaboot.ext.autoconfigure.core.utils.FileUtils;
import cn.com.duibaboot.ext.autoconfigure.security.DefensivePolicy;
import cn.com.duibaboot.ext.autoconfigure.security.SecurityPolicyProperties;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

public class FileUploudDefensivePolicy
implements DefensivePolicy {
    @Autowired
    private SecurityPolicyProperties policyProperties;
    private Set<String> whiteSuffix = Sets.newHashSet((Object[])new String[]{"jpg", "jpeg", "png", "gif", "xls", "xlsx", "csv", "pdf", "apk", "doc", "docx", "txt"});
    @Autowired
    private MultipartResolver resolver;

    @PostConstruct
    public void init() {
        String whiteSuffixStr = this.policyProperties.getUpload().getWhiteSuffixs();
        if (StringUtils.isBlank((CharSequence)whiteSuffixStr)) {
            return;
        }
        Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
        this.whiteSuffix.addAll(splitter.splitToList((CharSequence)whiteSuffixStr).stream().map(StringUtils::lowerCase).collect(Collectors.toSet()));
    }

    @Override
    public Set<MediaType> getMediaTypes() {
        return Sets.newHashSet((Object[])new MediaType[]{MediaType.MULTIPART_FORM_DATA});
    }

    @Override
    public void doDefensive(HttpServletRequest request, HttpServletResponse response) throws DuibaSecurityException {
        if (!this.resolver.isMultipart(request)) {
            return;
        }
        MultipartHttpServletRequest multipartRequest = this.resolver.resolveMultipart(request);
        Iterator iterator = multipartRequest.getFileNames();
        while (iterator.hasNext()) {
            String suffix;
            MultipartFile multipartFile = multipartRequest.getFile((String)iterator.next());
            String originalFilename = multipartFile.getOriginalFilename();
            if (StringUtils.isBlank((CharSequence)originalFilename) || !StringUtils.isNotBlank((CharSequence)(suffix = FileUtils.getFileSuffix(originalFilename, false))) || this.whiteSuffix.contains(StringUtils.lowerCase((String)suffix))) continue;
            throw new DuibaSecurityException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + suffix + "\u7c7b\u578b\u7684\u6587\u4ef6");
        }
    }

    public Set<String> getWhiteSuffix() {
        return this.whiteSuffix;
    }

    public void setWhiteSuffix(Set<String> whiteSuffix) {
        this.whiteSuffix = whiteSuffix;
    }
}

