/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.ext.autoconfigure.threadpool.proxy;

import java.lang.reflect.Field;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.util.ReflectionUtils;

public class MonitorCallable
implements Callable {
    private static final Logger logger = LoggerFactory.getLogger(MonitorCallable.class);
    private static final boolean IS_SLEUTH_CLASS_EXISTS;
    private static final Field DELEGATE_FIELD;
    private Callable callable;
    private BlockingQueue<Runnable> queue;
    private final long submitTimeMillis;

    public MonitorCallable(Callable callable) {
        this.callable = callable;
        this.submitTimeMillis = System.currentTimeMillis();
    }

    public MonitorCallable(Callable callable, BlockingQueue<Runnable> queue) {
        this(callable);
        this.queue = queue;
    }

    public long getSubmitTimeMillis() {
        return this.submitTimeMillis;
    }

    public Callable getCallable() {
        return this.callable;
    }

    public Object call() throws Exception {
        long waitTimeMillis = System.currentTimeMillis() - this.submitTimeMillis;
        if (waitTimeMillis >= 1000L) {
            if (this.queue == null) {
                logger.error("CallableClass:{},ThreadName:{} wait {} ms in queue, maybe corePoolSize is too small.", new Object[]{this.getRootCallable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis});
            } else {
                logger.error("CallableClass:{},ThreadName:{} wait {} ms in queue(queueSize:{}), maybe corePoolSize is too small.", new Object[]{this.getRootCallable().getClass().getName(), Thread.currentThread().getName(), waitTimeMillis, this.queue.size()});
            }
        }
        return this.callable.call();
    }

    protected Callable getRootCallable() {
        Callable tmp;
        Callable rootCallable = this.getCallable();
        if (IS_SLEUTH_CLASS_EXISTS && rootCallable instanceof TraceCallable && (tmp = (Callable)ReflectionUtils.getField((Field)DELEGATE_FIELD, (Object)rootCallable)) != null) {
            rootCallable = tmp;
        }
        return rootCallable;
    }

    static {
        boolean isSleuthClassExists = false;
        Field delegateField = null;
        try {
            Class.forName("org.springframework.cloud.sleuth.instrument.async.TraceCallable");
            isSleuthClassExists = true;
            delegateField = ReflectionUtils.findField(TraceCallable.class, (String)"delegate");
            if (delegateField == null) {
                throw new IllegalStateException("field delegate of class `TraceCallable` not found");
            }
            delegateField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SLEUTH_CLASS_EXISTS = isSleuthClassExists;
        DELEGATE_FIELD = delegateField;
    }
}

