package cn.com.duibaboot.ext.autoconfigure.cat.context;

import cn.com.duiba.boot.utils.NetUtils;
import com.dianping.cat.Cat;

/**
 * Created by houwen
 */
public class CatInstance {
    
    private static volatile boolean isEnable = true;

    static{
        String localIp = NetUtils.getLocalIp();
        //由于cat初始化时获取本机ip的方法比较慢，使用这个设置本机ip（cat内部会优先使用该设置）,从而加快cat启动速度
        System.setProperty("host.ip",localIp);
    }

    /**
     * 禁用 cat监控
     */
    public static void disable(){
        isEnable = false;
    }

    /**
     * 启用cat监控
     */
    public static void enable(){
        isEnable = true;
    }

    /**
     * 判断cat监控是否启用
     * @return
     */
    public static boolean isEnable(){
        return Cat.getManager().isCatEnabled() && isEnable;
    }
}
