package cn.com.duibaboot.ext.autoconfigure.data.etcd.actuate;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import java.util.Date;

@Endpoint(id="etcd-last-refresh-state")
public class EtcdLastRefreshStateEndpoint {

    private static volatile EtcdLastRefreshState etcdLastRefreshState;

    public static void markSuccess() {
        etcdLastRefreshState = new EtcdLastRefreshState(DateUtils.getSecondStr(new Date()), true);
    }

    public static void markFail() {
        etcdLastRefreshState = new EtcdLastRefreshState(DateUtils.getSecondStr(new Date()), false);
    }

    @ReadOperation
    public EtcdLastRefreshState getEtcdLastRefreshState() {
        return etcdLastRefreshState;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    static class EtcdLastRefreshState {

        private String refreshDatetime;

        private Boolean refreshState;
    }

}
