package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config;

import lombok.Getter;
import lombok.Setter;

/**
 * 数据源加密 - 字段相关的规则配置
 * Created by gyf .
 * 2020/7/28 .
 */
@Getter
@Setter
public final class DBEncryptColumnRule {

    /**
     * 明文列（真实列），用于存储数据明文数据，选填
     */
    private String plainColumn;

    /**
     * 密文列（真实列），用于存储数据密文数据，必填
     */
    private String cipherColumn;

    /**
     * 辅助查询字段，用于QueryAssistedEncryptAlgorithm
     * 它的理念是：即使是相同的数据，如两个用户的密码相同，它们在数据库里存储的加密数据也应当是不一样的。这种理念更有利于保护用户信息，防止撞库成功。
     * [该字段一般情况下不需要配置]
     */
    private String assistedQueryColumn;

    /**
     * 加密器，DuibaEncryptorRuleProperties 配置的加密器
     */
    private String encryptor;

}
