package cn.com.duibaboot.ext.autoconfigure.initserver.environment;

import lombok.Data;

import java.io.Serializable;
import java.util.Objects;

/**
 * @author liuyao
 */
@Data
public class ClusterKey implements Serializable {

    private Long envId;

    private String cluster;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterKey that = (ClusterKey) o;
        return Objects.equals(envId, that.envId) &&
                Objects.equals(cluster, that.cluster);
    }

    @Override
    public int hashCode() {
        return Objects.hash(envId, cluster);
    }

    @Override
    public String toString() {
        return "ClusterKey{" +
                "environment=" + DeployEnvironment.getEnvById(envId) +
                ", cluster='" + cluster + '\'' +
                '}';
    }
}
