package cn.com.duibaboot.ext.autoconfigure.initserver.environment;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Objects;

/**
 * 请使用Env
 * @author liuyao
 */

@Getter
public enum DeployEnvironment implements Serializable {

    /**
     * 开发环境
     */
    DEV(1L,"dev","开发环境"),
    /**
     * 测试环境
     */
    TEST(2L,"test","测试环境"),
    /**
     * 预发环境
     */
    @Deprecated
    PRE(3L,"pre","预发环境"),
    /**
     * 生产环境
     * 预发环境降级为生产环境的集群：3 : pre
     **/
    PROD(3L,"prod","生产环境");

    public static final String DEV_STR = "dev";
    public static final String TEST_STR = "test";

    private final Long id;
    private final String envId;
    private final String envName;

    private static DeployEnvironment currentEnvironment;

    DeployEnvironment(Long id, String envId, String envName){
        this.id = id;
        this.envId = envId;
        this.envName = envName;
    }

    public static DeployEnvironment getEnvByEnvId(String envId){
        Objects.requireNonNull(envId);
        switch (envId){
            case "dev":return DEV;
            case "test":return TEST;
            case "pre":return PRE;
            default:return PROD;
        }
    }

    public static DeployEnvironment getEnvById(Long id){
        Objects.requireNonNull(id);
        int indexForInt = id.intValue();
        switch (indexForInt){
            case 1:return DEV;
            case 2:return TEST;
            default:return PROD;
        }
    }

    public static DeployEnvironment getEnvByPrefix(String prefix){
        for(DeployEnvironment env: values()){
            if(StringUtils.startsWith(prefix,env.getEnvId())){
                return env;
            }
        }
        return null;
    }

    public static Boolean isOnline(DeployEnvironment environment){
        return Objects.equals(environment.getId(),3L);
    }

    public static DeployEnvironment parseEnvironmentEnum(String profiles){
        if(StringUtils.isBlank(profiles)){
            return PROD;
        }
        for(DeployEnvironment environment: values()){
            if(StringUtils.startsWith(profiles,environment.getEnvId())){
                return environment;
            }
        }
        return PROD;
    }

    public static DeployEnvironment getCurrentEnvironment(){
        if(Objects.isNull(currentEnvironment)){
            throw new RuntimeException("环境变量还未注入");
        }
        return currentEnvironment;
    }

    static void setCurrentEnvironment(DeployEnvironment environment){
        DeployEnvironment.currentEnvironment = environment;
    }


}
