package cn.com.duibaboot.ext.autoconfigure.initserver.environment;

import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.Objects;

/**
 * @author liuyao
 */
@EnableConfigurationProperties(ApplicationEnvironmentProperties.class)
public class DeployEnvironmentBootConfiguration {

    @Resource
    private ApplicationEnvironmentProperties applicationProperties;

    /**
     * 当前物理机部署的环境
     */
    @Bean
    public DeployEnvironment deployEnvironment(org.springframework.core.env.Environment environment){

        DeployEnvironment environmentForConfig = applicationProperties.getEnvironment();
        if(environmentForConfig!=null){
            DeployEnvironment.setCurrentEnvironment(environmentForConfig);
            return environmentForConfig;
        }
        String profiles = environment.getProperty(ConfigFileApplicationListener.ACTIVE_PROFILES_PROPERTY, DeployEnvironment.DEV.getEnvId());
        String[] profileArray = StringUtils.commaDelimitedListToStringArray(profiles);
        for(String profile:profileArray){
            DeployEnvironment current = DeployEnvironment.getEnvByPrefix(profile);
            if(Objects.nonNull(current)){
                DeployEnvironment.setCurrentEnvironment(current);
                return current;
            }
        }
        DeployEnvironment.setCurrentEnvironment(DeployEnvironment.DEV);
        return DeployEnvironment.DEV;
    }

    @Bean
    public ClusterEnvironmentService clusterEnvironmentService(){
        return new ClusterEnvironmentService();
    }

}
