/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.model.service.impl;

import cn.com.duiba.nezha.alg.model.tf.LocalTFModelV2;
import cn.com.duiba.spring.boot.starter.dsp.model.enums.AlgoTFModelStatusEnum;
import cn.com.duiba.spring.boot.starter.dsp.model.model.AlgoTFModel;
import cn.com.duiba.spring.boot.starter.dsp.model.service.AlgoTFModelProxy;
import cn.com.duiba.spring.boot.starter.dsp.model.support.ChooseTFModelStrategy;
import cn.com.duiba.spring.boot.starter.dsp.model.support.StrategyFactory;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgoTFModelProxyImpl
implements AlgoTFModelProxy {
    private static final Logger log = LoggerFactory.getLogger(AlgoTFModelProxyImpl.class);
    private static Random random = new Random();
    private String tfKey;
    private AlgoTFModel algoTFModel1;
    private AlgoTFModel algoTFModel2;
    private long tfModelUpdateTime;

    AlgoTFModelProxyImpl(String tfKey) throws Exception {
        this.tfKey = tfKey;
        LocalTFModelV2 localTFModel = new LocalTFModelV2();
        try {
            localTFModel.loadModel(tfKey);
        }
        catch (Exception e) {
            log.warn("localTFModel loadModel error...", (Throwable)e);
            throw e;
        }
        this.algoTFModel1 = new AlgoTFModel(localTFModel, AlgoTFModelStatusEnum.RUNNING.getCode(), tfKey + "-A");
        this.algoTFModel2 = new AlgoTFModel(AlgoTFModelStatusEnum.STOP.getCode(), tfKey + "-B");
    }

    @Override
    public LocalTFModelV2 chooseTFModel() {
        AlgoTFModel oldTFModel;
        AlgoTFModel newTFModel;
        if (!this.algoTFModel1.isRunning() && !this.algoTFModel2.isRunning()) {
            return null;
        }
        if (this.algoTFModel1.isRunning() && !this.algoTFModel2.isRunning()) {
            return this.algoTFModel1.getLocalTFModel();
        }
        if (!this.algoTFModel1.isRunning() && this.algoTFModel2.isRunning()) {
            return this.algoTFModel2.getLocalTFModel();
        }
        if (this.algoTFModel1.getLoadTime().compareTo(this.algoTFModel2.getLoadTime()) > 0) {
            newTFModel = this.algoTFModel1;
            oldTFModel = this.algoTFModel2;
        } else {
            newTFModel = this.algoTFModel2;
            oldTFModel = this.algoTFModel1;
        }
        Long loadTime = newTFModel.getLoadTime();
        if (System.currentTimeMillis() - loadTime >= 90000L) {
            return newTFModel.getLocalTFModel();
        }
        ChooseTFModelStrategy strategy = StrategyFactory.getStrategy();
        if (strategy.tryAcquire(loadTime)) {
            return newTFModel.getLocalTFModel();
        }
        return oldTFModel.getLocalTFModel();
    }

    @Override
    public void closeTFModel() {
        boolean allowClose1 = this.algoTFModel1.isAllowClose();
        boolean allowClose2 = this.algoTFModel2.isAllowClose();
        if (allowClose1) {
            this.algoTFModel1.doCloseTFModel();
        }
        if (allowClose2) {
            this.algoTFModel2.doCloseTFModel();
        }
    }

    @Override
    public boolean updateTFModel() {
        if (!this.algoTFModel1.isRunning() && !this.algoTFModel2.isRunning()) {
            return false;
        }
        LocalTFModelV2 localTFModel = new LocalTFModelV2();
        if (this.algoTFModel1.isRunning() && !this.algoTFModel2.isRunning() && this.algoTFModel1.isLatestVersion(localTFModel, this.tfKey)) {
            this.algoTFModel2.loadTFModel(localTFModel, this.tfKey);
            this.tfModelUpdateTime = System.currentTimeMillis();
            return true;
        }
        if (!this.algoTFModel1.isRunning() && this.algoTFModel2.isRunning() && this.algoTFModel2.isLatestVersion(localTFModel, this.tfKey)) {
            this.algoTFModel1.loadTFModel(localTFModel, this.tfKey);
            this.tfModelUpdateTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTwoRunningModel() {
        return this.algoTFModel1.isRunning() && this.algoTFModel2.isRunning();
    }

    @Override
    public boolean needFlush() {
        return !this.algoTFModel1.isRunning() && !this.algoTFModel2.isRunning();
    }

    public String getTfKey() {
        return this.tfKey;
    }

    public AlgoTFModel getAlgoTFModel1() {
        return this.algoTFModel1;
    }

    public AlgoTFModel getAlgoTFModel2() {
        return this.algoTFModel2;
    }

    public long getTfModelUpdateTime() {
        return this.tfModelUpdateTime;
    }

    public void setTfKey(String tfKey) {
        this.tfKey = tfKey;
    }

    public void setAlgoTFModel1(AlgoTFModel algoTFModel1) {
        this.algoTFModel1 = algoTFModel1;
    }

    public void setAlgoTFModel2(AlgoTFModel algoTFModel2) {
        this.algoTFModel2 = algoTFModel2;
    }

    public void setTfModelUpdateTime(long tfModelUpdateTime) {
        this.tfModelUpdateTime = tfModelUpdateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlgoTFModelProxyImpl)) {
            return false;
        }
        AlgoTFModelProxyImpl other = (AlgoTFModelProxyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tfKey = this.getTfKey();
        String other$tfKey = other.getTfKey();
        if (this$tfKey == null ? other$tfKey != null : !this$tfKey.equals(other$tfKey)) {
            return false;
        }
        AlgoTFModel this$algoTFModel1 = this.getAlgoTFModel1();
        AlgoTFModel other$algoTFModel1 = other.getAlgoTFModel1();
        if (this$algoTFModel1 == null ? other$algoTFModel1 != null : !((Object)this$algoTFModel1).equals(other$algoTFModel1)) {
            return false;
        }
        AlgoTFModel this$algoTFModel2 = this.getAlgoTFModel2();
        AlgoTFModel other$algoTFModel2 = other.getAlgoTFModel2();
        if (this$algoTFModel2 == null ? other$algoTFModel2 != null : !((Object)this$algoTFModel2).equals(other$algoTFModel2)) {
            return false;
        }
        return this.getTfModelUpdateTime() == other.getTfModelUpdateTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlgoTFModelProxyImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tfKey = this.getTfKey();
        result = result * 59 + ($tfKey == null ? 43 : $tfKey.hashCode());
        AlgoTFModel $algoTFModel1 = this.getAlgoTFModel1();
        result = result * 59 + ($algoTFModel1 == null ? 43 : ((Object)$algoTFModel1).hashCode());
        AlgoTFModel $algoTFModel2 = this.getAlgoTFModel2();
        result = result * 59 + ($algoTFModel2 == null ? 43 : ((Object)$algoTFModel2).hashCode());
        long $tfModelUpdateTime = this.getTfModelUpdateTime();
        result = result * 59 + (int)($tfModelUpdateTime >>> 32 ^ $tfModelUpdateTime);
        return result;
    }

    public String toString() {
        return "AlgoTFModelProxyImpl(tfKey=" + this.getTfKey() + ", algoTFModel1=" + this.getAlgoTFModel1() + ", algoTFModel2=" + this.getAlgoTFModel2() + ", tfModelUpdateTime=" + this.getTfModelUpdateTime() + ")";
    }
}

