/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.rateLimiter;

import cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LimitAspect {
    private static final Logger logger = LoggerFactory.getLogger(LimitAspect.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private DefaultRedisScript<Integer> redisLuaScript;

    @Pointcut(value="@annotation(cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit)")
    public void rateLimitPointcut() {
    }

    @Around(value="rateLimitPointcut()")
    public Object interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = method.getDeclaringClass();
        RateLimit rateLimit = method.getAnnotation(RateLimit.class);
        if (rateLimit != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String ipAddress = LimitAspect.getIpAddress(request);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ipAddress).append("-").append(targetClass.getName()).append("- ").append(method.getName()).append("-").append(rateLimit.key());
            List<String> keys = Collections.singletonList(stringBuffer.toString());
            Integer number = (Integer)this.stringRedisTemplate.execute(this.redisLuaScript, keys, new Object[]{rateLimit.count(), rateLimit.time()});
            if (number != null && number != 0 && number <= rateLimit.count()) {
                logger.info("\u9650\u6d41\u65f6\u95f4\u6bb5\u5185\u8bbf\u95ee\u7b2c\uff1a{} \u6b21", (Object)number.toString());
                return joinPoint.proceed();
            }
        } else {
            return joinPoint.proceed();
        }
        throw new RuntimeException("\u5df2\u7ecf\u5230\u8bbe\u7f6e\u9650\u6d41\u6b21\u6570");
    }

    private static String getIpAddress(HttpServletRequest request) {
        String ipAddress;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }
}

