/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.rateLimiter;

import cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit;
import cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimitProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LimitAspect {
    private static final Map<Long, Integer> redisNodeIndex = new ConcurrentHashMap<Long, Integer>();
    private static final Logger logger = LoggerFactory.getLogger(LimitAspect.class);
    private static final Map<String, AtomicLong> map = new ConcurrentHashMap<String, AtomicLong>();
    private static final Integer REDIS_NODE_NUM = 4;
    @Autowired
    private RateLimitProperties rateLimitProperties;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private DefaultRedisScript<Long> redisLuaScript;

    @Pointcut(value="@annotation(cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit)")
    public void rateLimitPointcut() {
    }

    @Around(value="rateLimitPointcut()")
    public Object interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        long limitCount;
        if (!this.rateLimitProperties.isAdxRateLimitSwitch()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = method.getDeclaringClass();
        RateLimit rateLimit = method.getAnnotation(RateLimit.class);
        if (rateLimit == null) {
            return joinPoint.proceed();
        }
        String commonRedisKey = "rate.limit:" + targetClass.getName() + "-" + method.getName() + "-" + rateLimit.key();
        long index = map.get(commonRedisKey).getAndIncrement() % (long)REDIS_NODE_NUM.intValue();
        String redisKey = commonRedisKey + "{" + redisNodeIndex.get(index) + "}";
        logger.info("\u9650\u6d41\u5566, redis key{}", (Object)redisKey);
        long totalLimitCount = rateLimit.count();
        long l = limitCount = totalLimitCount % (long)REDIS_NODE_NUM.intValue() > index ? totalLimitCount / (long)REDIS_NODE_NUM.intValue() + 1L : totalLimitCount / (long)REDIS_NODE_NUM.intValue();
        if (limitCount <= 0L) {
            throw new RuntimeException("\u5df2\u7ecf\u5230\u8bbe\u7f6e\u9650\u6d41\u6b21\u6570");
        }
        Long number = (Long)this.stringRedisTemplate.execute(this.redisLuaScript, Collections.singletonList(redisKey), new Object[]{String.valueOf(limitCount), String.valueOf(rateLimit.time())});
        if (Objects.nonNull(number) && number > 0L) {
            logger.info("\u9650\u6d41\u65f6\u95f4\u6bb5\u5185\u8bbf\u95ee\u7b2c\uff1a{} \u6b21", (Object)number);
            return joinPoint.proceed();
        }
        throw new RuntimeException("\u5df2\u7ecf\u5230\u8bbe\u7f6e\u9650\u6d41\u6b21\u6570");
    }

    static {
        map.put("rate.limit:cn.com.duiba.tuia.algo.engine.adx.service.v4.AdxAlgoService-execute-limit1", new AtomicLong());
        map.put("rate.limit:cn.com.duiba.tuia.algo.engine.adx.service.v4.AdxAlgoService-aaa-limit1", new AtomicLong());
        redisNodeIndex.put(0L, 14);
        redisNodeIndex.put(1L, 18);
        redisNodeIndex.put(2L, 296);
        redisNodeIndex.put(3L, 346);
        redisNodeIndex.put(4L, 29);
        redisNodeIndex.put(5L, 21);
        redisNodeIndex.put(6L, 32);
        redisNodeIndex.put(7L, 122);
        redisNodeIndex.put(8L, 69);
        redisNodeIndex.put(9L, 65);
        redisNodeIndex.put(10L, 76);
        redisNodeIndex.put(11L, 197);
        redisNodeIndex.put(12L, 50);
        redisNodeIndex.put(13L, 58);
        redisNodeIndex.put(14L, 223);
        redisNodeIndex.put(15L, 47);
    }
}

