package cn.com.duiba.spring.boot.starter.dsp.sampler;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CustomRequestInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        if (!SamplerLog.infoFlag()) {
            return;
        }
        template.header(SamplerLogConstant.RPC_SAMPLING_ID, SamplerLog.getSamplerId());
    }

}
