package cn.com.duiba.spring.boot.starter.dsp.sampler;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.openfeign.FeignClient;

@Slf4j
@Configuration
@ConditionalOnClass({FeignClient.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class DuibaRpcContextParamsInterceptor extends HandlerInterceptorAdapter {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String samplingId = request.getHeader(SamplerLogConstant.RPC_SAMPLING_ID);
        if (StringUtils.isBlank(samplingId)) {
            return true;
        }

        SamplerLog.setSamplerId(samplingId);
        return true;
    }
}
