package cn.com.duiba.spring.boot.starter.dsp.sampler.handler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SampleLogProperties;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description:
 * @date 2022/3/4 下午2:30
 */
public class ApolloPanGuHandler {

    @Resource
    private ApolloPanGuService apolloPanGuService;

    @Resource
    private SampleLogProperties sampleLogProperties;

    @Value("${sampler.log.default.size}")
    private Integer defaultSize;

    public Integer getSampling(String type, String value) {
        Map<String, String> extra = sampleLogProperties.getExtra();
        if (MapUtil.isEmpty(extra)) {
            return defaultSize;
        }
        String key = extra.get(type);
        Map<String, String> samplingMap = apolloPanGuService.getIdMapByKeyStr(key);
        if (MapUtil.isEmpty(samplingMap)) {
            return defaultSize;
        }
        String samplingStr = samplingMap.get(value);
        if (StringUtils.isNotEmpty(samplingStr) || !NumberUtil.isNumber(samplingStr)) {
            return defaultSize;
        }
        return Integer.parseInt(samplingStr);
    }
}
