/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.sampler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.handler.ApolloPanGuHandler;
import cn.hutool.core.lang.UUID;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerLog {
    private static final Logger log = LoggerFactory.getLogger(SamplerLog.class);
    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal();
    private static final Random random = new Random();
    @Resource
    private ApolloPanGuHandler apolloPanGuHandler;
    private static SamplerLog samplerLog;

    public static void start(String type, String value) {
        Integer sampling = SamplerLog.samplerLog.apolloPanGuHandler.getSampling(type, value);
        if (random.nextInt(sampling) == 0) {
            LOCAL.set((Object)UUID.randomUUID().toString(true));
        }
    }

    public static void info(String format, Object ... arguments) {
        try {
            if (SamplerLog.infoFlag()) {
                log.info("samplingId-" + (String)LOCAL.get() + "," + format, arguments);
            }
        }
        catch (Exception e) {
            log.warn("SamplerLog info error", (Throwable)e);
        }
    }

    public static void end() {
        LOCAL.remove();
    }

    public static String getSamplerId() {
        return (String)LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set((Object)samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    @PostConstruct
    public void init() {
        samplerLog = this;
        SamplerLog.samplerLog.apolloPanGuHandler = this.apolloPanGuHandler;
    }
}

