/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.sampler;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplerLog {
    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);
    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal();
    private static final Random random = new Random();

    public static void start(Integer samplingRate) {
        if (random.nextInt(samplingRate) != 0) {
            return;
        }
        LOCAL.set((Object)UUID.randomUUID().toString());
    }

    public static void end() {
        LOCAL.remove();
    }

    public static String getSamplerId() {
        return (String)LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set((Object)samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    public static void info(String format, Object ... arguments) {
        if (SamplerLog.infoFlag()) {
            logger.info("samplingId-" + (String)LOCAL.get() + "\uff0c" + format, arguments);
        }
    }
}

