/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.sampler.converter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.converter.SamplerLogConverter;
import cn.com.duiba.tuia.pangea.center.api.localservice.apollopangu.ApolloPanGuService;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.NumberUtil;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ApolloPanGuConverter
implements SamplerLogConverter {
    private static final Logger logger = LoggerFactory.getLogger(ApolloPanGuConverter.class);
    @Resource
    private ApolloPanGuService apolloPanGuService;
    @Value(value="${spring.application.name}")
    private String applicationName;

    @Override
    public Integer getSampling(String type, String value) {
        String panGuKey = this.applicationName + "_" + type;
        Map samplingMap = null;
        try {
            samplingMap = this.apolloPanGuService.getIdMapByKeyStr(panGuKey);
        }
        catch (Exception e) {
            logger.info("\u76d8\u53e4\u83b7\u53d6\u6837\u672c\u6570\u5f02\u5e38");
        }
        if (MapUtil.isEmpty((Map)samplingMap)) {
            return null;
        }
        String samplingStr = (String)samplingMap.get(value);
        if (StringUtils.isEmpty((CharSequence)samplingStr) || !NumberUtil.isNumber((String)samplingStr)) {
            return null;
        }
        return Integer.parseInt(samplingStr);
    }
}

