/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.sampler.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogConstant;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer", "provider"}, order=-2000)
public class DubboLogSamplerContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DubboLogSamplerContextFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = Objects.equals(sideKey, "consumer");
        if (isConsumerSide && StringUtils.isNotBlank((CharSequence)SamplerLog.getSamplerId())) {
            RpcContext.getContext().setAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID, SamplerLog.getSamplerId());
        } else {
            String samplingId = RpcContext.getContext().getAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID);
            SamplerLog.setSamplerId(samplingId);
        }
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            if (SamplerLog.infoFlag()) {
                SamplerLog.end();
            }
        }
    }
}

