package cn.com.duiba.spring.boot.starter.dsp.enums;

/**
 * @author jiangyangyang
 * @version 1.0
 * @description: redis8分片解决均匀分布key枚举类, 主要是先尝试获取所有节点的key，然后根据hash tag实现均匀分布
 * @date 2022/1/6 上午10:28
 */
public enum RedisBalance8KeyEnum {

    KEY01(1, "01"),

    KEY02(2, "02"),

    KEY03(3, "03"),

    KEY04(4, "04"),

    KEY05(5, "05"),

    KEY06(6, "06"),

    KEY07(7, "07"),

    KEY08(8, "07");

    public int order;

    public String hashTag;

    RedisBalance8KeyEnum(int order, String hashTag) {
        this.order = order;
        this.hashTag = hashTag;
    }
}
