package cn.com.duiba.spring.boot.starter.dsp.util;

import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CatUtils {

    /**
     * 日志工具
     */
    private static final Logger logger = LoggerFactory.getLogger(CatUtils.class);

    /**
     * 业务指标日志-次数统计
     * @param bizName
     */
    public static void log(String bizName){
        try {
            Cat.logMetricForCount(bizName);
        } catch (Exception e){
            logger.error("CatTools.MetricForCount · { Cat } 指标计数 :: Error : 异常 , [ 指标名称 : {} ] , 请检查错误并修复. ", bizName, e);
        }
    }

    /**
     * 对callback内部执行的代码加上cat监控
     *
     * @param callback 要监控耗时的代码段
     * @param type
     * @param name
     * @param <T>
     * @return
     */
    public static <T> T executeInCatTransaction(cn.com.duibaboot.ext.autoconfigure.core.utils.CatUtils.Callback<T> callback, String type, String name) throws Throwable{
        return CatUtils.executeInCatTransaction(callback, type, name);
    }




}
