package cn.com.duiba.spring.boot.starter.dsp.warmup;

import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import java.util.concurrent.ConcurrentMap;

/** Cache对象管理器
 * @author MeiChang
 * @Description
 */
public class CacheManager {

    /**
     * 使用单例保存所有Cache对象
     */
    private static final ConcurrentMap<String, Object> allCacheMap = Maps.newConcurrentMap();


    static void saveCache(String key, Object value) {

        if (StringUtils.isBlank(key)) {
            return;
        }

        allCacheMap.put(key, value);
    }

    public static ConcurrentMap<String, Object> getCacheMap(){
        return allCacheMap;
    }
}
