/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.warmup;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttp(String url, Map<String, String> param, String appName) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(150).setSocketTimeout(150).setConnectionRequestTimeout(100).build()).setMaxConnPerRoute(1).setMaxConnTotal(1000).evictExpiredConnections().setUserAgent(appName).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).disableCookieManagement().useSystemProperties().disableRedirectHandling().setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long time = super.getKeepAliveDuration(response, context);
                if (time == -1L) {
                    time = 30000L;
                }
                return time;
            }
        }).build();
        String resultString = "";
        CloseableHttpResponse response = null;
        try {
            URI uri;
            HttpGet httpGet;
            URIBuilder builder = new URIBuilder(url);
            if (param != null) {
                for (String key : param.keySet()) {
                    builder.addParameter(key, param.get(key));
                }
            }
            if ((response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(uri = builder.build())))).getStatusLine().getStatusCode() == 200) {
                resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            } else {
                log.warn("Cache preheating failed\uff0cbecause response {}", (Object)JSON.toJSONString((Object)response, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }
}

