/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.warmup;

import cn.com.duiba.boot.event.MainContextRefreshedEvent;
import cn.com.duiba.boot.utils.AopTargetUtils;
import cn.com.duiba.spring.boot.starter.dsp.warmup.CacheManager;
import cn.com.duiba.spring.boot.starter.dsp.warmup.HttpRequestUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.google.common.cache.Cache;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureOrder(value=-2147483648)
public class CacheConfig {
    private static final Logger logger = LoggerFactory.getLogger(CacheConfig.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Resource(name="eurekaClient")
    private EurekaClient eurekaClient;
    @Value(value="${spring.application.name}")
    private String appName;
    @Value(value="${local.cache.warmup.enable:false}")
    private Boolean cacheEnable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={MainContextRefreshedEvent.class})
    public void onMainContextRefreshed() {
        String[] names;
        for (String beanName : names = this.applicationContext.getBeanDefinitionNames()) {
            try {
                Field[] fields;
                String packageName;
                Object bean = this.applicationContext.getBean(beanName);
                Class<?> beanObjClass = bean.getClass();
                Package pkg = beanObjClass.getPackage();
                if (pkg == null || (packageName = pkg.getName()).startsWith("springfox.") || packageName.startsWith("org.") || packageName.startsWith("io.") || packageName.startsWith("net.") || packageName.startsWith("cn.com.duibaboot") || packageName.startsWith("com.netflix") || packageName.startsWith("cn.com.duiba.tuia.pangea")) continue;
                if (AopUtils.isAopProxy((Object)bean)) {
                    try {
                        bean = AopTargetUtils.getTarget((Object)bean);
                    }
                    catch (Exception e) {
                        logger.error("\u4ee3\u7406\u7c7b\u83b7\u53d6\u539f\u59cb\u7c7b\u5931\u8d25");
                    }
                }
                if ((fields = bean.getClass().getDeclaredFields()).length == 0) continue;
                for (Field field : fields) {
                    boolean isGuava = Cache.class.isAssignableFrom(field.getType());
                    boolean isCaffeine = AsyncCache.class.isAssignableFrom(field.getType());
                    if (!isCaffeine && !isGuava) continue;
                    field.setAccessible(true);
                    String keyName = String.format("%s-%s", beanName, field.getName());
                    try {
                        ConcurrentMap concurrentMap;
                        Object cache = field.get(bean);
                        if (cache instanceof Cache) {
                            concurrentMap = ((Cache)cache).asMap();
                            CacheManager.saveCache(keyName, concurrentMap);
                            logger.info("beanName = {}, cache = {}, isGuava = {}, bean = {}", new Object[]{keyName, cache, isGuava, bean});
                        }
                        if (!(cache instanceof AsyncCache)) continue;
                        concurrentMap = ((AsyncCache)cache).synchronous().asMap();
                        CacheManager.saveCache(keyName, concurrentMap);
                        logger.info("beanName = {}, cache = {}, isCaffeine = {}, bean = {}", new Object[]{keyName, cache, isCaffeine, bean});
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    finally {
                        field.setAccessible(false);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("cache\u5b9e\u4f8b\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @EventListener(value={MainContextRefreshedEvent.class})
    @Order(value=0x7FFFFFFE)
    public void onServerCache() {
        try {
            if (!this.cacheEnable.booleanValue()) {
                logger.warn("Cache preheating failed\uff0cbecause cacheEnable is false");
                return;
            }
            List instances = this.eurekaClient.getApplication(this.appName).getInstances();
            if (CollectionUtils.isEmpty((Collection)instances)) {
                logger.warn("\u83b7\u53d6\u5bb9\u5668\u5217\u8868\u4e3a\u7a7a!");
                return;
            }
            logger.info("container of all registered AppInfo size: {}", (Object)instances.size());
            List list = instances.stream().sorted((o1, o2) -> (int)(o2.getLeaseInfo().getServiceUpTimestamp() - o1.getLeaseInfo().getServiceUpTimestamp())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                logger.warn("Cache preheating failed\uff0cbecause \u670d\u52a1\u542f\u52a8\u83b7\u53d6\u3010" + this.appName + "\u3011\u5217\u8868\u4fe1\u606f\u4e3a\u7a7a");
                return;
            }
            logger.info("\u6253\u5370warmup\u83b7\u53d6\u5907\u4efd\u6570\u636e\u5b9e\u4f8b\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(list.get(0)));
            String result = HttpRequestUtils.sendHttp(((InstanceInfo)list.get(0)).getHomePageUrl() + "/local/getCacheMap", null, this.appName);
            if (StringUtils.isBlank((CharSequence)result)) {
                logger.warn("Cache preheating failed\uff0cbecause request {} ,response {}", (Object)(((InstanceInfo)list.get(0)).getHomePageUrl() + "/local/getCacheMap"), (Object)result);
                return;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            TypeFactory typeFactory = objectMapper.getTypeFactory();
            Map map = (Map)objectMapper.convertValue(JSONObject.parse((String)result), (JavaType)typeFactory.constructMapType(Map.class, String.class, Object.class));
            map.forEach((k, v) -> {
                Field[] fields;
                String[] split = k.split("-");
                Object bean = this.applicationContext.getBean(split[0]);
                if (AopUtils.isAopProxy((Object)bean)) {
                    try {
                        bean = AopTargetUtils.getTarget((Object)bean);
                    }
                    catch (Exception e) {
                        logger.error("\u4ee3\u7406\u7c7b\u83b7\u53d6\u539f\u59cb\u7c7b\u5931\u8d25");
                    }
                }
                for (Field field : fields = bean.getClass().getDeclaredFields()) {
                    if (!field.getName().equals(split[1]) || ((JSONObject)JSONObject.parse((String)JSON.toJSONString((Object)v))).size() <= 0) continue;
                    try {
                        field.setAccessible(true);
                        Object obj = field.get(bean);
                        if (!(obj instanceof Cache) && !(obj instanceof AsyncCache)) continue;
                        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
                        Type[] actualTypeArguments = genericType.getActualTypeArguments();
                        MapType mapType = typeFactory.constructMapType(Map.class, (Class)actualTypeArguments[0], Object.class);
                        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        Map convertMap = (Map)objectMapper.convertValue(v, (JavaType)mapType);
                        if (obj instanceof Cache) {
                            Cache cache = (Cache)obj;
                            convertMap.forEach((k1, v1) -> {
                                ParameterizedType genericType1 = (ParameterizedType)actualTypeArguments[1];
                                Type[] actualTypeArguments1 = genericType1.getActualTypeArguments();
                                JavaType javaType = typeFactory.constructType(actualTypeArguments1[0]);
                                cache.put(k1, Optional.ofNullable(objectMapper.convertValue(v1, javaType)));
                            });
                            logger.info("Guava Cache key = {} ; Guava Cache Size = {}", k, (Object)cache.asMap().size());
                        }
                        if (obj instanceof AsyncCache) {
                            AsyncCache asyncCache = (AsyncCache)obj;
                            convertMap.forEach((k1, v1) -> {
                                ParameterizedType genericType1 = (ParameterizedType)actualTypeArguments[1];
                                Type[] actualTypeArguments1 = genericType1.getActualTypeArguments();
                                JavaType javaType = typeFactory.constructType(actualTypeArguments1[0]);
                                asyncCache.put(k1, CompletableFuture.supplyAsync(() -> Optional.ofNullable(objectMapper.convertValue(v1, javaType))));
                            });
                            logger.info("Caffeine Cache key = {} ; Caffeine Cache Size = {}", k, (Object)asyncCache.synchronous().asMap().size());
                        }
                        field.setAccessible(false);
                    }
                    catch (Exception e) {
                        logger.warn("this bean : {} , no have method : {}, Lead to it cannot be deserialized , cause: {}", new Object[]{split[0], field.getName() + " Serialize", e});
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("\u670d\u52a1\u542f\u52a8\u83b7\u53d6\u3010" + this.appName + "\u3011\u5217\u8868\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }
}

