package cn.com.duibaboot.ext.autoconfigure.dubbo.init;

import cn.com.duibaboot.ext.autoconfigure.dubbo.core.DubboSpecifiedBeanPostProcessor;
import org.apache.dubbo.rpc.service.EchoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

/**
 * 应用启动时初始化，防止第一次请求执行慢
 */
@Configuration
@AutoConfigureOrder(Ordered.HIGHEST_PRECEDENCE)
public class InitDubboServerAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(InitDubboServerAutoConfiguration.class);

    @Bean
    public static DubboBeanPostProcessorOfSpecified dubboBeanPostProcessorOfSpecified() {
        return new DubboBeanPostProcessorOfSpecified();
    }

    @Bean
    public DubboBootstrapListenerForAsyncSpecified dubboBootstrapListenerForAsyncSpecified(DubboBeanPostProcessorOfSpecified dubboBeanPostProcessorOfSpecified) {
        return new DubboBootstrapListenerForAsyncSpecified(dubboBeanPostProcessorOfSpecified.getDubboAsyncProcessor2BeansMap());
    }

    /**
     * 并发初始化Dubbo
     */
    @Configuration
    public static class DubboPostProcessorConfiguration {

        @Bean
        public DubboSpecifiedBeanPostProcessor dubboPostProcessorConfigurer() {
            return new DubboSpecifiedBeanPostProcessor<EchoService>() {

                @Override
                public Class<EchoService> getBeanType() {
                    return EchoService.class;
                }

                @Override
                public void postProcessAfterInitialization(EchoService echoService, String beanName) {
                    //dubbo回声检测，用于检测dubbo调用链路是否通畅 （即初始化dubbo）
                    try {
                        echoService.$echo("OK");
                    } catch (Exception e) {
                        logger.error(e.getMessage(), e);
                    }
                }
            };
        }
    }

}
